/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.factionsone;

import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import java.util.Map;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.impl.factionsone.FOPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;

public class FOClaim
extends ConquerClaim<Chunk> {
    private static Map<Object, FOClaim> cache = new WeakHashMap<Object, FOClaim>();
    private Chunk chunk;
    private Factions factions;
    private FLocation fLocation;

    private FOClaim(FOPlugin plugin, FLocation fLocation) {
        this.chunk = Bukkit.getWorld((String)fLocation.getWorldName()).getChunkAt(Math.toIntExact(fLocation.getX()), Math.toIntExact(fLocation.getZ()));
        this.factions = plugin.getFactions();
        this.fLocation = fLocation;
    }

    private FOClaim(FOPlugin plugin, Chunk chunk) {
        this.chunk = chunk;
        this.factions = plugin.getFactions();
        this.fLocation = new FLocation(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    public static FOClaim get(FOPlugin plugin, FLocation fLocation) {
        if (fLocation == null) {
            return null;
        }
        if (!cache.containsKey(fLocation)) {
            FOClaim foClaim = new FOClaim(plugin, fLocation);
            cache.put(fLocation, foClaim);
            return foClaim;
        }
        return cache.get(fLocation);
    }

    public static FOClaim get(FOPlugin plugin, Chunk chunk) {
        if (chunk == null) {
            return null;
        }
        if (!cache.containsKey(chunk)) {
            FOClaim fuClaim = new FOClaim(plugin, chunk);
            cache.put(chunk, fuClaim);
        }
        return cache.get(chunk);
    }

    @Override
    public Chunk getRepresentation() {
        return this.chunk;
    }

    @Override
    public ClaimType getType() {
        Faction faction = Board.getFactionAt((FLocation)this.fLocation);
        if (faction.isNone()) {
            return ClaimType.WILDERNESS;
        }
        if (faction.getId().equals("-1")) {
            return ClaimType.SAFE_ZONE;
        }
        if (faction.getId().equals("-2")) {
            return ClaimType.WAR_ZONE;
        }
        return ClaimType.FACTION;
    }

    @Override
    public void setTo(ClaimType type) {
        Faction faction;
        switch (type) {
            case WILDERNESS: {
                faction = this.factions.get("0");
                break;
            }
            case SAFE_ZONE: {
                faction = this.factions.get("-1");
                break;
            }
            case WAR_ZONE: {
                faction = this.factions.get("-2");
                break;
            }
            default: {
                return;
            }
        }
        Board.setFactionAt((Faction)faction, (FLocation)this.fLocation);
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("chunk", (Object)this.chunk);
        return fields;
    }

    public FLocation getRawFLocation() {
        return this.fLocation;
    }
}

