/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer;

import ch.njol.skript.Skript;
import ch.njol.skript.SkriptAddon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import me.andrew28.addons.conquer.DefaultFactionPlugins;
import me.andrew28.addons.conquer.api.EventForwarder;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import me.andrew28.addons.conquer.org.bstats.bukkit.Metrics;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Conquer
extends JavaPlugin {
    private static Conquer instance;
    private boolean usingSkript;
    private SkriptAddon addonInstance;
    private FactionsPlugin factions;
    private EventForwarder currentForwarder;
    private boolean registeredElements = false;

    public void onEnable() {
        instance = this;
        this.usingSkript = this.getServer().getPluginManager().isPluginEnabled("Skript");
        if (!this.usingSkript) {
            this.getLogger().info("Skript is not installed, so Skript elements will not be registered. Other plugins may still use Conquer's API though.");
        }
        Metrics metrics = new Metrics(this);
        metrics.addCustomChart(new Metrics.SimplePie("factions_plugin_name", () -> this.factions == null ? "None" : this.factions.getName()));
        this.loadFactions();
        this.getServer().getScheduler().runTask((Plugin)this, () -> {
            if (this.factions == null) {
                this.getLogger().log(Level.SEVERE, "No other faction plugins have been registered, make sure you have a compatible one installed and restart your server.");
            }
        });
    }

    private void loadFactions() {
        ArrayList<String> names = new ArrayList<String>();
        for (DefaultFactionPlugins plugin : DefaultFactionPlugins.values()) {
            FactionsPlugin factions;
            try {
                factions = plugin.getImplClass().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
                continue;
            }
            String name = factions.getName();
            if (factions.canUse()) {
                this.setFactions(factions);
                return;
            }
            names.add(name);
        }
        this.getLogger().warning("None of the default faction plugins were found: " + String.join((CharSequence)", ", names));
        this.getLogger().warning("Waiting for other faction plugins to register..");
    }

    private void registerElements() {
        if (this.registeredElements) {
            throw new IllegalStateException("Elements have already been registered.");
        }
        try {
            this.getAddonInstance().loadClasses("me.andrew28.addons.conquer", new String[]{"skript"});
            this.registeredElements = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isUsingSkript() {
        return this.usingSkript;
    }

    public EventForwarder getCurrentForwarder() {
        return this.currentForwarder;
    }

    public boolean hasRegisteredElements() {
        return this.registeredElements;
    }

    public SkriptAddon getAddonInstance() {
        if (this.addonInstance == null) {
            this.addonInstance = Skript.registerAddon((JavaPlugin)this);
        }
        return this.addonInstance;
    }

    public FactionsPlugin getFactions() {
        return this.factions;
    }

    public void setFactions(FactionsPlugin factions) {
        factions.init();
        if (this.currentForwarder != null) {
            HandlerList.unregisterAll((Listener)this.currentForwarder);
        }
        this.currentForwarder = factions.getEventForwarder();
        if (this.currentForwarder != null) {
            this.getServer().getPluginManager().registerEvents((Listener)this.currentForwarder, (Plugin)this);
        }
        this.factions = factions;
        this.getLogger().warning("Using factions plugin: " + factions.getName());
        if (this.usingSkript && !this.registeredElements) {
            this.registerElements();
        }
    }

    public static Conquer getInstance() {
        return instance;
    }
}

