/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Warp Password")
@Description(value={"The warp password of a warp of a faction. Some faction plugins can not give this, but can set it."})
@Examples(value={"set the warp password of the warp \"jail\" for player's faction to \"correcthorsebatterystaple\""})
public class ExprWarpPassword
extends SimpleExpression<String> {
    private Expression<String> name;
    private Expression<ConquerFaction> faction;

    protected String[] get(Event e) {
        String name = (String)this.name.getSingle(e);
        ConquerFaction faction = (ConquerFaction)this.faction.getSingle(e);
        if (name == null || faction == null) {
            return null;
        }
        return new String[]{faction.getWarpPassword(name)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "warp password of warp " + this.name.toString(e, debug) + " of faction " + this.faction.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.name = exprs[0];
        this.faction = exprs[1];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        String name = (String)this.name.getSingle(e);
        ConquerFaction faction = (ConquerFaction)this.faction.getSingle(e);
        if (name == null || faction == null) {
            return;
        }
        switch (mode) {
            case SET: {
                if (delta == null || delta.length == 0 || delta[0] == null) {
                    return;
                }
                faction.setWarpPassword(name, (String)delta[0]);
                break;
            }
            case REMOVE_ALL: 
            case RESET: 
            case DELETE: {
                faction.setWarpPassword(name, null);
            }
        }
    }

    static {
        Skript.registerExpression(ExprWarpPassword.class, String.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] warp pass[word] (of|for) [the] warp %string% (of|for) [the] [faction] %conquerfaction%"});
    }
}

