/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Set;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Warp Names of Faction")
@Description(value={"The warp names of a faction"})
@Examples(value={"send \"Valid Warps: %warp names of player's faction%\""})
public class ExprWarpNamesOfFaction
extends SimpleExpression<String> {
    private Expression<ConquerFaction> faction;

    protected String[] get(Event e) {
        ConquerFaction faction = (ConquerFaction)this.faction.getSingle(e);
        if (faction == null || faction.getWarps() == null) {
            return null;
        }
        Set<String> warps = faction.getWarps().keySet();
        return warps.toArray(new String[warps.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "warp names of " + this.faction.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.faction = exprs[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerFaction faction = (ConquerFaction)this.faction.getSingle(e);
        if (faction == null) {
            return;
        }
        if (mode == Changer.ChangeMode.REMOVE) {
            if (delta == null || delta.length == 0 || delta[0] == null) {
                return;
            }
            String name = (String)delta[0];
            faction.getWarps().remove(name);
        } else {
            faction.getWarps().clear();
        }
    }

    static {
        Skript.registerExpression(ExprWarpNamesOfFaction.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] warp names of %conquerfaction%", "%conquerfaction%'s warp names"});
    }
}

