/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="TNT of Faction")
@Description(value={"Gets the amount of TNT a faction has"})
@Examples(value={"send \"Your faction has %tnt amount of player's faction%\""})
public class ExprFactionTNT
extends SimplePropertyExpression<ConquerFaction, Integer> {
    protected String getPropertyName() {
        return "tnt stored";
    }

    public Integer convert(ConquerFaction faction) {
        return faction.getTNT();
    }

    public Class<? extends Integer> getReturnType() {
        return Integer.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{Number.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerFaction[] factions = (ConquerFaction[])this.getExpr().getArray(e);
        if (factions == null) {
            return;
        }
        block9: for (ConquerFaction faction : factions) {
            if (faction == null) continue;
            block0 : switch (mode) {
                case RESET: {
                    faction.setTNT(0);
                    continue block9;
                }
                case SET: 
                case ADD: 
                case REMOVE: {
                    if (delta == null || delta.length == 0 || delta[0] == null) {
                        return;
                    }
                    int amount = ((Number)delta[0]).intValue();
                    switch (mode) {
                        case SET: {
                            faction.setTNT(amount);
                            break block0;
                        }
                        case ADD: {
                            faction.addTNT(amount);
                            break block0;
                        }
                        case REMOVE: {
                            faction.removeTNT(amount);
                        }
                    }
                }
            }
        }
    }

    static {
        ExprFactionTNT.register(ExprFactionTNT.class, Integer.class, (String)"tnt [(amount|cache[d]|stor(ed|age))]", (String)"conquerfaction");
    }
}

