/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Faction Rules")
@Description(value={"Gets the rules of a faction"})
@Examples(value={"add \"Always give all of your diamonds to Notch.\" to rules of player's faction"})
public class ExprFactionRules
extends SimpleExpression<String> {
    private Expression<ConquerFaction> factions;

    protected String[] get(Event e) {
        ConquerFaction[] factions;
        ArrayList<String> rules = new ArrayList<String>();
        for (ConquerFaction faction : factions = (ConquerFaction[])this.factions.getArray(e)) {
            List<String> factionRules;
            if (faction == null || (factionRules = faction.getRules()) == null) continue;
            rules.addAll(factionRules);
        }
        return rules.toArray(new String[rules.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public String toString(Event e, boolean debug) {
        return "the rules of " + this.factions.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.factions = exprs[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerFaction[] factions = (ConquerFaction[])this.factions.getArray(e);
        if (factions == null) {
            return;
        }
        block5: for (ConquerFaction faction : factions) {
            List<String> rules;
            if (faction == null || (rules = faction.getRules()) == null) continue;
            switch (mode) {
                case SET: {
                    if (delta == null) {
                        return;
                    }
                    rules.clear();
                    rules.addAll(Arrays.asList((String[])delta));
                    continue block5;
                }
                case RESET: 
                case DELETE: {
                    rules.clear();
                    continue block5;
                }
                case ADD: {
                    if (delta == null || delta.length == 0 || delta[0] == null) {
                        return;
                    }
                    rules.add((String)delta[0]);
                }
            }
        }
    }

    static {
        Skript.registerExpression(ExprFactionRules.class, String.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] rule[s] [list] of [the] [faction][s] %conquerfactions%", "[the] [faction][s] %conquerfactions%'[s] rule[s] [list]"});
    }
}

