/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.legacyfactions;

import ch.njol.yggdrasil.Fields;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.api.sender.MessageOnlySender;
import me.andrew28.addons.conquer.impl.legacyfactions.LFClaim;
import me.andrew28.addons.conquer.impl.legacyfactions.LFPlayer;
import me.andrew28.addons.conquer.impl.legacyfactions.LFPlugin;
import net.redstoneore.legacyfactions.Lang;
import net.redstoneore.legacyfactions.RelationParticipator;
import net.redstoneore.legacyfactions.entity.Board;
import net.redstoneore.legacyfactions.entity.FPlayerColl;
import net.redstoneore.legacyfactions.entity.Faction;
import net.redstoneore.legacyfactions.entity.FactionColl;
import net.redstoneore.legacyfactions.warp.FactionWarp;
import net.redstoneore.legacyfactions.warp.FactionWarps;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class LFFaction
extends ConquerFaction {
    private static final String DEFAULT_DESCRIPTION = Lang.GENERIC_DEFAULTDESCRIPTION.toString();
    private static Map<Faction, LFFaction> cache = new WeakHashMap<Faction, LFFaction>();
    private LFPlugin plugin;
    private FactionColl factionColl;
    private Board board;
    private Faction faction;
    private FactionWarps factionWarps;
    private CommandSender sender;
    private Map<String, Location> warpMap;

    private LFFaction(LFPlugin plugin, Faction faction) {
        this.plugin = plugin;
        this.factionColl = plugin.getFactionColl();
        this.board = plugin.getBoard();
        this.faction = faction;
        this.factionWarps = faction.warps();
    }

    public static LFFaction get(LFPlugin plugin, Faction faction) {
        if (faction == null || !faction.isNormal() || faction.getId().equals("-1") || faction.getId().equals("-2")) {
            return null;
        }
        if (!cache.containsKey(faction)) {
            LFFaction lfFaction = new LFFaction(plugin, faction);
            cache.put(faction, lfFaction);
            return lfFaction;
        }
        return cache.get(faction);
    }

    @Override
    public String getId() {
        return this.faction.getId();
    }

    @Override
    public void setId(String id) {
        this.faction.setId(id);
    }

    @Override
    public String getName() {
        return this.faction.getTag();
    }

    @Override
    public void setName(String name) {
        this.faction.setTag(name);
    }

    @Override
    public String getDescription() {
        String description = this.faction.getDescription();
        return description == null ? DEFAULT_DESCRIPTION : description;
    }

    @Override
    public void setDescription(String description) {
        if (description == null) {
            description = DEFAULT_DESCRIPTION;
        }
        this.faction.setDescription(description);
    }

    @Override
    public String getMotd() {
        return null;
    }

    @Override
    public void setMotd(String motd) {
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.faction.getFoundedDate());
    }

    @Override
    public void setCreationDate(Date date) {
        this.faction.setFoundedDate(date.getTime());
    }

    @Override
    public double getPower() {
        return this.faction.getPower();
    }

    @Override
    public void setPower(double power) {
        this.faction.setPermanentPower(Integer.valueOf((int)power));
    }

    @Override
    public double getMaximumPower() {
        return this.faction.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.faction.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.faction.setPowerBoost(powerBoost);
    }

    @Override
    public ConquerPlayer getLeader() {
        return LFPlayer.get(this.plugin, this.faction.getOwner());
    }

    @Override
    public void setLeader(ConquerPlayer leader) {
        leader.setRole(ConquerPlayer.Role.ADMIN);
    }

    @Override
    public Location getHome() {
        return this.faction.getHome();
    }

    @Override
    public void setHome(Location home) {
        this.faction.setHome(home);
    }

    @Override
    public ConquerPlayer[] getMembers() {
        return (ConquerPlayer[])this.faction.getFPlayers().stream().map(fPlayer -> LFPlayer.get(this.plugin, fPlayer)).toArray(ConquerPlayer[]::new);
    }

    @Override
    public void addMember(ConquerPlayer member) {
        ((LFPlayer)member).getRawPlayer().setFaction(this.faction);
    }

    @Override
    public void removeMember(ConquerPlayer member) {
        this.faction.removeFPlayer(((LFPlayer)member).getRawPlayer());
    }

    @Override
    public CommandSender getSender() {
        if (this.sender == null) {
            this.sender = new MessageOnlySender(){

                public void sendMessage(String message) {
                    LFFaction.this.faction.sendMessage(message);
                }

                @Override
                public void sendMessage(String[] messages) {
                    LFFaction.this.faction.sendMessage(Arrays.asList(messages));
                }
            };
        }
        return this.sender;
    }

    @Override
    public Map<String, Location> getWarps() {
        if (this.warpMap == null) {
            this.warpMap = new AbstractMap<String, Location>(){

                @Override
                public Location get(Object key) {
                    if (!(key instanceof String)) {
                        return null;
                    }
                    Optional optional = LFFaction.this.factionWarps.get((String)key);
                    return optional.isPresent() ? ((FactionWarp)optional.get()).getLocation() : null;
                }

                @Override
                public boolean containsKey(Object key) {
                    return key instanceof String && LFFaction.this.factionWarps.get((String)key).isPresent();
                }

                @Override
                public Location put(String key, Location value) {
                    Location previous = this.get(key);
                    LFFaction.this.factionWarps.setWarp(key, value);
                    return previous;
                }

                @Override
                public Set<Map.Entry<String, Location>> entrySet() {
                    return LFFaction.this.factionWarps.getAll().stream().map(warp -> new AbstractMap.SimpleEntry<String, Location>(warp.getName(), warp.getLocation())).collect(Collectors.toSet());
                }
            };
        }
        return this.warpMap;
    }

    @Override
    public boolean hasWarpPassword(String warp) {
        Optional optional = this.factionWarps.get(warp);
        if (!optional.isPresent()) {
            return false;
        }
        return ((FactionWarp)optional.get()).hasPassword();
    }

    @Override
    public boolean isWarpPassword(String warp, String password) {
        Optional optional = this.factionWarps.get(warp);
        if (!optional.isPresent()) {
            return false;
        }
        return ((FactionWarp)optional.get()).isPassword(password);
    }

    @Override
    public String getWarpPassword(String warp) {
        Optional optional = this.factionWarps.get(warp);
        if (!optional.isPresent()) {
            return null;
        }
        return ((FactionWarp)optional.get()).getPassword();
    }

    @Override
    public void setWarpPassword(String warp, String password) {
        Optional optional = this.factionWarps.get(warp);
        if (!optional.isPresent()) {
            return;
        }
        FactionWarp factionWarp = (FactionWarp)optional.get();
        this.factionWarps.setWarp(warp, factionWarp.getLocation(), password);
    }

    @Override
    public Set<ConquerPlayer> getInvited() {
        return this.faction.getInvites().stream().map(FPlayerColl::get).map(fPlayer -> LFPlayer.get(this.plugin, fPlayer)).collect(Collectors.toSet());
    }

    @Override
    public void invite(ConquerPlayer player) {
        this.faction.invite(((LFPlayer)player).getRawPlayer());
    }

    @Override
    public void deinvite(ConquerPlayer player) {
        this.faction.deinvite(((LFPlayer)player).getRawPlayer());
    }

    @Override
    public boolean isPeaceful() {
        return this.faction.isPeaceful();
    }

    @Override
    public void setPeaceful(boolean peaceful) {
        this.faction.setPeaceful(peaceful);
    }

    @Override
    public boolean isOpen() {
        return this.faction.getOpen();
    }

    @Override
    public void setOpen(boolean open) {
        this.faction.setOpen(open);
    }

    @Override
    public Relation getRelationTo(ConquerFaction faction) {
        return this.plugin.translate(this.faction.getRelationTo((RelationParticipator)((LFFaction)faction).getRawFaction()));
    }

    @Override
    public void setRelationBetween(ConquerFaction faction, Relation relation) {
        this.faction.setRelationWish(((LFFaction)faction).getRawFaction(), this.plugin.translate(relation));
    }

    @Override
    public ConquerClaim<?>[] getClaims() {
        return (ConquerClaim[])this.faction.getAllClaims().stream().map(fLocation -> LFClaim.get(this.plugin, fLocation)).toArray(ConquerClaim[]::new);
    }

    @Override
    public void claim(ConquerClaim<?> claim) {
        this.board.setFactionAt(this.faction, ((LFClaim)claim).getRawFLocation());
    }

    @Override
    public void claim(Location location) {
    }

    @Override
    public void unclaim(ConquerClaim<?> claim) {
        this.board.removeAt(((LFClaim)claim).getRawFLocation());
    }

    @Override
    public void unclaim(Location location) {
        this.board.removeAt(this.plugin.translate(location));
    }

    @Override
    public void disband() {
        this.factionColl.removeFaction(this.faction.getId());
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("id", (Object)this.faction.getId());
        return fields;
    }

    public Faction getRawFaction() {
        return this.faction;
    }
}

