/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.legacyfactions;

import java.util.Iterator;
import java.util.Map;
import me.andrew28.addons.conquer.api.EventForwarder;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.api.events.ConquerFactionCreateEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionDisbandEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionJoinEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionLeaveEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationWishEvent;
import me.andrew28.addons.conquer.api.events.ConquerLandClaimEvent;
import me.andrew28.addons.conquer.api.events.ConquerPlayerFactionEvent;
import me.andrew28.addons.conquer.api.events.ConquerPowerLossEvent;
import me.andrew28.addons.conquer.impl.legacyfactions.LFClaim;
import me.andrew28.addons.conquer.impl.legacyfactions.LFFaction;
import me.andrew28.addons.conquer.impl.legacyfactions.LFPlayer;
import me.andrew28.addons.conquer.impl.legacyfactions.LFPlugin;
import net.redstoneore.legacyfactions.FLocation;
import net.redstoneore.legacyfactions.entity.Faction;
import net.redstoneore.legacyfactions.event.EventFactionsChange;
import net.redstoneore.legacyfactions.event.EventFactionsCreate;
import net.redstoneore.legacyfactions.event.EventFactionsDisband;
import net.redstoneore.legacyfactions.event.EventFactionsLandChange;
import net.redstoneore.legacyfactions.event.EventFactionsPowerLoss;
import net.redstoneore.legacyfactions.event.EventFactionsRelation;
import net.redstoneore.legacyfactions.event.EventFactionsRelationChange;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;

class LFEventForwarder
extends EventForwarder {
    private LFPlugin plugin;

    LFEventForwarder(LFPlugin plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onFactionCreate(EventFactionsCreate event) {
        ConquerFactionCreateEvent forwardEvent = new ConquerFactionCreateEvent(LFPlayer.get(this.plugin, event.getFPlayer()), event.getFactionTag());
        this.callEvent(forwardEvent);
        if (forwardEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFactionDisband(EventFactionsDisband event) {
        ConquerFactionDisbandEvent forwardEvent = new ConquerFactionDisbandEvent(LFFaction.get(this.plugin, event.getFaction()), LFPlayer.get(this.plugin, event.getFPlayer()));
        this.callEvent(forwardEvent);
        if (forwardEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onFactionsChange(EventFactionsChange event) {
        ConquerPlayerFactionEvent forwardEvent = event.getFactionNew().isWilderness() ? new ConquerFactionLeaveEvent(LFFaction.get(this.plugin, event.getFactionOld()), LFPlayer.get(this.plugin, event.getFPlayer())) : new ConquerFactionJoinEvent(LFFaction.get(this.plugin, event.getFactionNew()), LFPlayer.get(this.plugin, event.getFPlayer()));
        this.callEvent(forwardEvent);
        if (((Cancellable)forwardEvent).isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onRelationChange(EventFactionsRelation event) {
        Relation oldRelation = this.plugin.translate(event.getOldRelation());
        Relation newRelation = this.plugin.translate(event.getRelation());
        LFFaction faction = LFFaction.get(this.plugin, event.getFaction());
        LFFaction targetFaction = LFFaction.get(this.plugin, event.getTargetFaction());
        ConquerFactionRelationEvent forwardEvent = new ConquerFactionRelationEvent(faction, targetFaction, oldRelation, newRelation);
        this.callEvent(forwardEvent);
    }

    @EventHandler
    public void onRelationWish(EventFactionsRelationChange event) {
        LFPlayer caller = LFPlayer.get(this.plugin, event.getfPlayer());
        Relation oldRelation = this.plugin.translate(event.getCurrentRelation());
        Relation newRelation = this.plugin.translate(event.getTargetRelation());
        LFFaction faction = LFFaction.get(this.plugin, event.getFaction());
        LFFaction targetFaction = LFFaction.get(this.plugin, event.getTargetFaction());
        ConquerFactionRelationWishEvent forwardEvent = new ConquerFactionRelationWishEvent(caller, faction, targetFaction, oldRelation, newRelation);
        this.callEvent(forwardEvent);
        if (forwardEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onLandChange(EventFactionsLandChange event) {
        boolean claiming = event.getCause() == EventFactionsLandChange.LandChangeCause.Claim;
        LFPlayer player = LFPlayer.get(this.plugin, event.getFPlayer());
        Iterator iterator = event.getTransactions().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            LFClaim claim = LFClaim.get(this.plugin, (FLocation)entry.getKey());
            LFFaction faction = LFFaction.get(this.plugin, (Faction)entry.getValue());
            ConquerLandClaimEvent forwardEvent = new ConquerLandClaimEvent(claim, claiming, faction, player);
            this.callEvent(forwardEvent);
            if (!forwardEvent.isCancelled()) continue;
            iterator.remove();
        }
    }

    @EventHandler
    public void onPowerLoss(EventFactionsPowerLoss event) {
        LFPlayer player = LFPlayer.get(this.plugin, event.getfPlayer());
        LFFaction faction = LFFaction.get(this.plugin, event.getFaction());
        ConquerPowerLossEvent forwardEvent = new ConquerPowerLossEvent(faction, player);
        this.callEvent(forwardEvent);
        if (forwardEvent.isCancelled()) {
            event.setCancelled(true);
        }
    }
}

