/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.factionsone;

import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.FPlayers;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import com.massivecraft.factions.iface.RelationParticipator;
import com.massivecraft.factions.struct.FFlag;
import com.massivecraft.factions.struct.TerritoryAccess;
import com.massivecraft.factions.zcore.persist.Entity;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.api.sender.MessageOnlySender;
import me.andrew28.addons.conquer.impl.factionsone.FOClaim;
import me.andrew28.addons.conquer.impl.factionsone.FOPlayer;
import me.andrew28.addons.conquer.impl.factionsone.FOPlugin;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class FOFaction
extends ConquerFaction {
    private static final String DEFAULT_DESCRIPTION = "Default faction description :(";
    private static Method setIdMethod;
    private static Field flocationIdsField;
    private static Map<Faction, FOFaction> cache;
    private FOPlugin plugin;
    private Factions factions;
    private FPlayers fPlayers;
    private Faction faction;
    private CommandSender sender;

    private FOFaction(FOPlugin plugin, Faction faction) {
        this.plugin = plugin;
        this.factions = plugin.getFactions();
        this.fPlayers = plugin.getfPlayers();
        this.faction = faction;
    }

    public static FOFaction get(FOPlugin plugin, Faction faction) {
        if (faction == null || !faction.isNormal() || faction.getId().equals("-1") || faction.getId().equals("-2")) {
            return null;
        }
        if (!cache.containsKey(faction)) {
            FOFaction foFaction = new FOFaction(plugin, faction);
            cache.put(faction, foFaction);
            return foFaction;
        }
        return cache.get(faction);
    }

    @Override
    public String getId() {
        return this.faction.getId();
    }

    @Override
    public void setId(String id) {
        try {
            setIdMethod.invoke((Object)this.faction, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.faction.getTag();
    }

    @Override
    public void setName(String name) {
        this.faction.setTag(name);
    }

    @Override
    public String getDescription() {
        String description = this.faction.getDescription();
        return description.equals(DEFAULT_DESCRIPTION) ? null : description;
    }

    @Override
    public void setDescription(String description) {
        this.faction.setDescription(description == null ? DEFAULT_DESCRIPTION : description);
    }

    @Override
    public String getMotd() {
        return null;
    }

    @Override
    public void setMotd(String motd) {
    }

    @Override
    public Date getCreationDate() {
        return null;
    }

    @Override
    public void setCreationDate(Date date) {
    }

    @Override
    public double getPower() {
        return this.faction.getPower();
    }

    @Override
    public void setPower(double power) {
    }

    @Override
    public double getMaximumPower() {
        return this.faction.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.faction.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.faction.setPowerBoost(powerBoost);
    }

    @Override
    public ConquerPlayer getLeader() {
        return FOPlayer.get(this.plugin, this.faction.getFPlayerLeader());
    }

    @Override
    public void setLeader(ConquerPlayer leader) {
        leader.setRole(ConquerPlayer.Role.ADMIN);
    }

    @Override
    public Location getHome() {
        return this.faction.getHome();
    }

    @Override
    public void setHome(Location home) {
        this.faction.setHome(home);
    }

    @Override
    public ConquerPlayer[] getMembers() {
        return (ConquerPlayer[])this.faction.getFPlayers().stream().map(fPlayer -> FOPlayer.get(this.plugin, fPlayer)).toArray(ConquerPlayer[]::new);
    }

    @Override
    public void addMember(ConquerPlayer member) {
        ((FOPlayer)member).getRawPlayer().setFaction(this.faction);
    }

    @Override
    public void removeMember(ConquerPlayer member) {
        ((FOPlayer)member).getRawPlayer().setFaction(this.factions.get("0"));
    }

    @Override
    public CommandSender getSender() {
        if (this.sender == null) {
            this.sender = new MessageOnlySender(){

                public void sendMessage(String message) {
                    FOFaction.this.faction.sendMessage(message);
                }

                @Override
                public void sendMessage(String[] messages) {
                    FOFaction.this.faction.sendMessage(Arrays.asList(messages));
                }
            };
        }
        return this.sender;
    }

    @Override
    public Map<String, Location> getWarps() {
        return null;
    }

    @Override
    public boolean hasWarpPassword(String warp) {
        return false;
    }

    @Override
    public boolean isWarpPassword(String warp, String password) {
        return false;
    }

    @Override
    public String getWarpPassword(String warp) {
        return null;
    }

    @Override
    public void setWarpPassword(String warp, String password) {
    }

    @Override
    public Set<ConquerPlayer> getInvited() {
        return this.faction.getInvites().stream().map(id -> (FPlayer)this.fPlayers.get(id)).map(fPlayer -> FOPlayer.get(this.plugin, fPlayer)).collect(Collectors.toSet());
    }

    @Override
    public void invite(ConquerPlayer player) {
        this.faction.invite(((FOPlayer)player).getRawPlayer());
    }

    @Override
    public void deinvite(ConquerPlayer player) {
        this.faction.deinvite(((FOPlayer)player).getRawPlayer());
    }

    @Override
    public boolean isPeaceful() {
        return this.faction.getFlag(FFlag.PEACEFUL);
    }

    @Override
    public void setPeaceful(boolean peaceful) {
        this.faction.setFlag(FFlag.PEACEFUL, peaceful);
    }

    @Override
    public boolean isOpen() {
        return this.faction.getOpen();
    }

    @Override
    public void setOpen(boolean open) {
        this.faction.setOpen(open);
    }

    @Override
    public Relation getRelationTo(ConquerFaction faction) {
        return this.plugin.translateRelation(this.faction.getRelationTo((RelationParticipator)((FOFaction)faction).getRawFaction()));
    }

    @Override
    public void setRelationBetween(ConquerFaction faction, Relation relation) {
        this.faction.setRelationWish(((FOFaction)faction).getRawFaction(), this.plugin.translateRelation(relation));
    }

    private Map<FLocation, TerritoryAccess> getflocationIds() {
        try {
            return (Map)flocationIdsField.get(null);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ConquerClaim<?>[] getClaims() {
        HashSet<FOClaim> claims = new HashSet<FOClaim>();
        Map<FLocation, TerritoryAccess> map = this.getflocationIds();
        if (map == null) {
            return null;
        }
        for (Map.Entry<FLocation, TerritoryAccess> entry : map.entrySet()) {
            String id = entry.getValue().getHostFactionID();
            if (!Objects.equals(id, this.faction.getId())) continue;
            claims.add(FOClaim.get(this.plugin, entry.getKey()));
        }
        return claims.toArray(new ConquerClaim[claims.size()]);
    }

    @Override
    public void claim(ConquerClaim<?> claim) {
        Board.setFactionAt((Faction)this.faction, (FLocation)((FOClaim)claim).getRawFLocation());
    }

    @Override
    public void claim(Location location) {
        Board.setFactionAt((Faction)this.faction, (FLocation)this.plugin.translate(location));
    }

    @Override
    public void unclaim(ConquerClaim<?> claim) {
        Board.setFactionAt((Faction)this.factions.get("0"), (FLocation)((FOClaim)claim).getRawFLocation());
    }

    @Override
    public void unclaim(Location location) {
        Board.setFactionAt((Faction)this.factions.get("0"), (FLocation)this.plugin.translate(location));
    }

    @Override
    public void disband() {
        this.faction.detach();
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("id", (Object)this.faction.getId());
        return fields;
    }

    public Faction getRawFaction() {
        return this.faction;
    }

    static {
        try {
            setIdMethod = Entity.class.getDeclaredMethod("setId", String.class);
            flocationIdsField = Board.class.getDeclaredField("flocationIds");
            flocationIdsField.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            e.printStackTrace();
        }
        cache = new WeakHashMap<Faction, FOFaction>();
    }
}

