/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import org.bukkit.event.Event;

@Name(value="Type of Claim")
@Description(value={"Gets the type of a claim"})
@Examples(value={"if type of claim at player is wilderness:", "\tsend \"Open up your Pokemon GO app and catch them all (especially Pikachu)!\""})
public class ExprTypeOfClaim
extends SimplePropertyExpression<ConquerClaim, ClaimType> {
    protected String getPropertyName() {
        return "claim type";
    }

    public ClaimType convert(ConquerClaim conquerClaim) {
        return conquerClaim.getType();
    }

    public Class<? extends ClaimType> getReturnType() {
        return ClaimType.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{ClaimType.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerClaim[] claims = (ConquerClaim[])this.getExpr().getArray(e);
        if (claims == null) {
            return;
        }
        ClaimType type = ClaimType.WILDERNESS;
        if (mode == Changer.ChangeMode.SET) {
            if (delta == null || delta.length == 0) {
                return;
            }
            type = (ClaimType)((Object)delta[0]);
            if (type == null) {
                type = ClaimType.WILDERNESS;
            }
        }
        for (ConquerClaim claim : claims) {
            if (claim == null) continue;
            claim.setTo(type);
        }
    }

    static {
        ExprTypeOfClaim.register(ExprTypeOfClaim.class, ClaimType.class, (String)"[claim] type", (String)"conquerclaims");
    }
}

