/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.ScriptLoader;
import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.skript.log.ErrorQuality;
import ch.njol.util.Kleenean;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationWishEvent;
import org.bukkit.event.Event;

@Name(value="Relation Change (Wish) Sender/Target Faction")
@Description(value={"Gets the sender/target faction of a relation change (wish)"})
@Examples(value={"on faction relation change:", "\tbroadcast \"%sender faction% changed their relation to %target faction% to %new relation%\""})
public class ExprRelationFactionSenderTarget
extends SimpleExpression<ConquerFaction> {
    private boolean sender;

    protected ConquerFaction[] get(Event e) {
        ConquerFaction faction;
        if (e instanceof ConquerFactionRelationEvent) {
            ConquerFactionRelationEvent event = (ConquerFactionRelationEvent)e;
            faction = this.sender ? event.getSender() : event.getTarget();
        } else if (e instanceof ConquerFactionRelationWishEvent) {
            ConquerFactionRelationWishEvent event = (ConquerFactionRelationWishEvent)e;
            faction = this.sender ? event.getSender() : event.getTarget();
        } else {
            return null;
        }
        return new ConquerFaction[]{faction};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ConquerFaction> getReturnType() {
        return ConquerFaction.class;
    }

    public String toString(Event e, boolean debug) {
        return this.sender ? "sender" : "target faction";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        if (!ScriptLoader.isCurrentEvent((Class[])new Class[]{ConquerFactionRelationEvent.class, ConquerFactionRelationWishEvent.class})) {
            Skript.error((String)"The faction relation sender/target expression may only be used in faction relation change/wish events.", (ErrorQuality)ErrorQuality.SEMANTIC_ERROR);
            return false;
        }
        this.sender = matchedPattern == 1;
        return true;
    }

    static {
        Skript.registerExpression(ExprRelationFactionSenderTarget.class, ConquerFaction.class, (ExpressionType)ExpressionType.SIMPLE, (String[])new String[]{"[the] sender faction", "[the] target faction"});
    }
}

