/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.util.Date;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Last Activity of Faction Player")
@Description(value={"Gets the last activity of a faction player"})
@Examples(value={"send \"Last Login Dates:\"", "loop members of player's faction:", "\tsend \"%loop-player%: %last login date of loop-player%\""})
public class ExprPlayerLastActivity
extends SimplePropertyExpression<ConquerPlayer, ch.njol.skript.util.Date> {
    protected String getPropertyName() {
        return "last activity date";
    }

    public ch.njol.skript.util.Date convert(ConquerPlayer player) {
        return new ch.njol.skript.util.Date(player.getLastActivity().getTime());
    }

    public Class<? extends ch.njol.skript.util.Date> getReturnType() {
        return ch.njol.skript.util.Date.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{ch.njol.skript.util.Date.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerPlayer player = (ConquerPlayer)this.getExpr().getSingle(e);
        if (player == null || delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        player.setLastActivity(new Date(((ch.njol.skript.util.Date)delta[0]).getTimestamp()));
    }

    static {
        ExprPlayerLastActivity.register(ExprPlayerLastActivity.class, ch.njol.skript.util.Date.class, (String)"[the] last [faction] (activity|login) [date]", (String)"conquerplayers");
    }
}

