/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="MOTD of Faction")
@Description(value={"The message of the day (MOTD) of a faction"})
@Examples(value={"send \"Your faction's motd: %motd of player's faction%\""})
public class ExprMotdOfFaction
extends SimplePropertyExpression<ConquerFaction, String> {
    protected String getPropertyName() {
        return "motd";
    }

    public String convert(ConquerFaction faction) {
        return faction.getMotd();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        ConquerFaction faction = (ConquerFaction)this.getExpr().getSingle(e);
        faction.setMotd((String)delta[0]);
    }

    static {
        ExprMotdOfFaction.register(ExprMotdOfFaction.class, String.class, (String)"[the] (motd|message of the day)", (String)"conquerfactions");
    }
}

