/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.FactionResolver;
import org.bukkit.event.Event;

@Name(value="Faction with Name")
@Description(value={"Gets the faction with a specified name"})
@Examples(value={"if faction with name \"Umbaska\" is set:", "\tsend \"Ducky is in us all.\""})
public class ExprFactionWithName
extends SimpleExpression<ConquerFaction> {
    private Expression<String> names;

    protected ConquerFaction[] get(Event e) {
        FactionResolver resolver = Conquer.getInstance().getFactions().getFactionResolver();
        ArrayList<ConquerFaction> factions = new ArrayList<ConquerFaction>();
        String[] names = (String[])this.names.getArray(e);
        if (names == null) {
            return null;
        }
        for (String name : names) {
            ConquerFaction faction;
            if (name == null || (faction = resolver.getByName(name)) == null) continue;
            factions.add(faction);
        }
        return factions.toArray(new ConquerFaction[factions.size()]);
    }

    public boolean isSingle() {
        return this.names.isSingle();
    }

    public Class<? extends ConquerFaction> getReturnType() {
        return ConquerFaction.class;
    }

    public String toString(Event e, boolean debug) {
        return "factions with name" + (this.names.isSingle() ? "" : "s") + " " + this.names.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.names = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprFactionWithName.class, ConquerFaction.class, (ExpressionType)ExpressionType.COMBINED, (String[])new String[]{"[the] faction[s] with (name|tag)[s] %strings%"});
    }
}

