/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.legacyfactions;

import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.impl.legacyfactions.LFFaction;
import me.andrew28.addons.conquer.impl.legacyfactions.LFPlugin;
import net.redstoneore.legacyfactions.entity.FPlayer;
import net.redstoneore.legacyfactions.entity.FPlayerColl;
import net.redstoneore.legacyfactions.entity.FactionColl;
import org.bukkit.OfflinePlayer;

public class LFPlayer
extends ConquerPlayer {
    private static Map<Object, LFPlayer> cache = new WeakHashMap<Object, LFPlayer>();
    private LFPlugin plugin;
    private FactionColl factionColl;
    private FPlayer fPlayer;
    private OfflinePlayer offlinePlayer;

    private LFPlayer(LFPlugin plugin, FPlayer fPlayer) {
        this.plugin = plugin;
        this.factionColl = plugin.getFactionColl();
        this.fPlayer = fPlayer;
        this.offlinePlayer = fPlayer.getPlayer();
    }

    private LFPlayer(LFPlugin plugin, OfflinePlayer player) {
        this.plugin = plugin;
        this.factionColl = plugin.getFactionColl();
        this.fPlayer = FPlayerColl.get((Object)player);
        this.offlinePlayer = player;
    }

    public static LFPlayer get(LFPlugin plugin, FPlayer mPlayer) {
        if (mPlayer == null) {
            return null;
        }
        if (!cache.containsKey(mPlayer)) {
            LFPlayer lfPlayer = new LFPlayer(plugin, mPlayer);
            cache.put(mPlayer, lfPlayer);
            return lfPlayer;
        }
        return cache.get(mPlayer);
    }

    public static LFPlayer get(LFPlugin plugin, OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        if (!cache.containsKey(player)) {
            LFPlayer lfPlayer = new LFPlayer(plugin, player);
            cache.put(player, lfPlayer);
            return lfPlayer;
        }
        return cache.get(player);
    }

    @Override
    public String getName() {
        return this.offlinePlayer.getName();
    }

    @Override
    public boolean hasFaction() {
        return this.fPlayer.getFaction().isNormal();
    }

    @Override
    public ConquerFaction getFaction() {
        return LFFaction.get(this.plugin, this.fPlayer.getFaction());
    }

    @Override
    public void setFaction(ConquerFaction faction) {
        this.fPlayer.setFaction(faction == null ? this.factionColl.getWilderness() : ((LFFaction)faction).getRawFaction());
    }

    @Override
    public boolean isAutoClaiming() {
        return this.fPlayer.getAutoClaimFor() != null;
    }

    @Override
    public void setAutoClaiming(boolean autoClaiming) {
        this.fPlayer.setAutoClaimFor(this.fPlayer.getFaction());
    }

    @Override
    public Date getLastActivity() {
        return new Date(this.fPlayer.getLastLoginTime());
    }

    @Override
    public void setLastActivity(Date date) {
        this.fPlayer.setLastFrostwalkerMessage();
    }

    @Override
    public ConquerPlayer.Role getRole() {
        return this.plugin.translate(this.fPlayer.getRole());
    }

    @Override
    public void setRole(ConquerPlayer.Role role) {
        this.fPlayer.setRole(this.plugin.translate(role));
    }

    @Override
    public String getTitle() {
        return this.fPlayer.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.fPlayer.setTitle(title);
    }

    @Override
    public void leaveFaction() {
        this.fPlayer.leave(false);
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    @Override
    public double getPower() {
        return this.fPlayer.getPower();
    }

    @Override
    public void setPower(double power) {
        this.fPlayer.alterPower(power - this.getPower());
    }

    @Override
    public double getMaximumPower() {
        return this.fPlayer.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.fPlayer.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.fPlayer.setPowerBoost(powerBoost);
    }

    public FPlayer getRawPlayer() {
        return this.fPlayer;
    }
}

