/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Faction Role of Player")
@Description(value={"The role of a faction player"})
@Examples(value={"send \"Your role: %faction role of player%\""})
public class ExprPlayerRole
extends SimplePropertyExpression<ConquerPlayer, ConquerPlayer.Role> {
    protected String getPropertyName() {
        return "faction role";
    }

    public ConquerPlayer.Role convert(ConquerPlayer player) {
        return player.getRole();
    }

    public Class<? extends ConquerPlayer.Role> getReturnType() {
        return ConquerPlayer.Role.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{ConquerPlayer.Role.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerPlayer[] players = (ConquerPlayer[])this.getExpr().getArray(e);
        if (players == null) {
            return;
        }
        ConquerPlayer.Role role = ConquerPlayer.Role.NORMAL;
        if (mode == Changer.ChangeMode.SET) {
            if (delta == null || delta.length == 0 || delta[0] == null) {
                return;
            }
            role = (ConquerPlayer.Role)((Object)delta[0]);
        }
        for (ConquerPlayer player : players) {
            if (player == null) continue;
            player.setRole(role);
        }
    }

    static {
        ExprPlayerRole.register(ExprPlayerRole.class, ConquerPlayer.Role.class, (String)"[the] [faction] role", (String)"conquerplayers");
    }
}

