/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Invited Players")
@Description(value={"The invited players of a faction"})
@Examples(value={"send \"Gotta all those invites!\"", "clear the invites of player's faction"})
public class ExprInvitedPlayers
extends SimpleExpression<ConquerPlayer> {
    private Expression<ConquerFaction> factions;

    protected ConquerPlayer[] get(Event e) {
        ConquerFaction[] factions;
        HashSet<ConquerPlayer> players = new HashSet<ConquerPlayer>();
        for (ConquerFaction faction : factions = (ConquerFaction[])this.factions.getArray(e)) {
            if (faction == null) continue;
            players.addAll(faction.getInvited());
        }
        return players.toArray(new ConquerPlayer[players.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends ConquerPlayer> getReturnType() {
        return ConquerPlayer.class;
    }

    public String toString(Event e, boolean debug) {
        return "invited players of " + this.factions.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.factions = exprs[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{ConquerPlayer[].class};
        }
        if (mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{ConquerPlayer.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerFaction[] factions = (ConquerFaction[])this.factions.getArray(e);
        if (factions == null) {
            return;
        }
        block0 : switch (mode) {
            case SET: 
            case REMOVE: 
            case ADD: {
                if (delta == null || delta.length == 0) {
                    return;
                }
                List<Object> players = Arrays.asList(delta);
                switch (mode) {
                    case SET: {
                        for (ConquerFaction faction : factions) {
                            if (faction == null) continue;
                            for (ConquerPlayer conquerPlayer : players) {
                                if (conquerPlayer == null || faction.getInvited().contains(conquerPlayer)) continue;
                                faction.invite(conquerPlayer);
                            }
                            for (ConquerPlayer conquerPlayer : faction.getInvited()) {
                                if (conquerPlayer == null || players.contains(conquerPlayer)) continue;
                                faction.deinvite(conquerPlayer);
                            }
                        }
                        break block0;
                    }
                    case REMOVE: {
                        for (ConquerFaction faction : factions) {
                            players.forEach(faction::deinvite);
                        }
                        break block0;
                    }
                    case ADD: {
                        for (ConquerFaction faction : factions) {
                            players.forEach(faction::invite);
                        }
                    }
                }
                break;
            }
            case REMOVE_ALL: 
            case DELETE: {
                for (ConquerFaction faction : factions) {
                    if (faction == null) continue;
                    for (ConquerPlayer conquerPlayer : faction.getInvited()) {
                        if (conquerPlayer == null) continue;
                        faction.deinvite(conquerPlayer);
                    }
                }
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprInvitedPlayers.class, ConquerPlayer.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] invited players of %conquerfactions%", "%conquerfactions%'s invited players"});
    }
}

