/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import java.util.Date;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Creation Date of Faction")
@Description(value={"The creation date of a faction"})
@Examples(value={"send \"Your faction was created %difference between now and creation date of player's faction% ago.\""})
public class ExprCreationDateOfFaction
extends SimplePropertyExpression<ConquerFaction, ch.njol.skript.util.Date> {
    protected String getPropertyName() {
        return "creation date";
    }

    public ch.njol.skript.util.Date convert(ConquerFaction faction) {
        Date date = faction.getCreationDate();
        return date == null ? null : new ch.njol.skript.util.Date(date.getTime());
    }

    public Class<? extends ch.njol.skript.util.Date> getReturnType() {
        return ch.njol.skript.util.Date.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{ch.njol.skript.util.Date.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        ConquerFaction faction = (ConquerFaction)this.getExpr().getSingle(e);
        faction.setCreationDate(new Date(((ch.njol.skript.util.Date)delta[0]).getTimestamp()));
    }

    static {
        ExprCreationDateOfFaction.register(ExprCreationDateOfFaction.class, ch.njol.skript.util.Date.class, (String)"creation date", (String)"conquerfactions");
    }
}

