/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.mfactions;

import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.MPlayer;
import java.util.Date;
import java.util.Map;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.impl.mfactions.MSFaction;
import me.andrew28.addons.conquer.impl.mfactions.MSPlugin;
import org.bukkit.OfflinePlayer;

public class MSPlayer
extends ConquerPlayer {
    private static Map<Object, MSPlayer> cache = new WeakHashMap<Object, MSPlayer>();
    private MSPlugin plugin;
    private FactionColl factionColl;
    private MPlayer mPlayer;
    private OfflinePlayer offlinePlayer;

    private MSPlayer(MSPlugin plugin, MPlayer mPlayer) {
        this.plugin = plugin;
        this.factionColl = plugin.getFactionColl();
        this.mPlayer = mPlayer;
        this.offlinePlayer = mPlayer.getPlayer();
    }

    private MSPlayer(MSPlugin plugin, OfflinePlayer player) {
        this.plugin = plugin;
        this.factionColl = plugin.getFactionColl();
        this.mPlayer = (MPlayer)plugin.getmPlayerColl().get((Object)player.getUniqueId());
        this.offlinePlayer = player;
    }

    public static MSPlayer get(MSPlugin plugin, MPlayer mPlayer) {
        if (mPlayer == null) {
            return null;
        }
        if (!cache.containsKey(mPlayer)) {
            MSPlayer msPlayer = new MSPlayer(plugin, mPlayer);
            cache.put(mPlayer, msPlayer);
            return msPlayer;
        }
        return cache.get(mPlayer);
    }

    public static MSPlayer get(MSPlugin plugin, OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        if (!cache.containsKey(player)) {
            MSPlayer msPlayer = new MSPlayer(plugin, player);
            cache.put(player, msPlayer);
            return msPlayer;
        }
        return cache.get(player);
    }

    @Override
    public String getName() {
        return this.offlinePlayer.getName();
    }

    @Override
    public boolean hasFaction() {
        return this.mPlayer.getFaction().isNormal();
    }

    @Override
    public MSFaction getFaction() {
        return MSFaction.get(this.plugin, this.mPlayer.getFaction());
    }

    @Override
    public void setFaction(ConquerFaction faction) {
        this.mPlayer.setFaction(faction == null ? this.factionColl.getNone() : ((MSFaction)faction).getRawFaction());
    }

    @Override
    public boolean isAutoClaiming() {
        return this.mPlayer.getAutoClaimFaction() != null;
    }

    @Override
    public void setAutoClaiming(boolean autoClaiming) {
        this.mPlayer.setAutoClaimFaction(this.mPlayer.getFaction());
    }

    @Override
    public Date getLastActivity() {
        return new Date(this.mPlayer.getLastActivityMillis());
    }

    @Override
    public void setLastActivity(Date date) {
        this.mPlayer.setLastActivityMillis(date.getTime());
    }

    @Override
    public ConquerPlayer.Role getRole() {
        return this.plugin.translateRole(this.mPlayer.getRole());
    }

    @Override
    public void setRole(ConquerPlayer.Role role) {
        this.mPlayer.setRole(this.plugin.translateRole(role));
    }

    @Override
    public String getTitle() {
        return this.mPlayer.hasTitle() ? this.mPlayer.getTitle() : null;
    }

    @Override
    public void setTitle(String title) {
        this.mPlayer.setTitle(title);
    }

    @Override
    public void leaveFaction() {
        this.mPlayer.leave();
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public MPlayer getRawPlayer() {
        return this.mPlayer;
    }

    @Override
    public double getPower() {
        return this.mPlayer.getPower();
    }

    @Override
    public void setPower(double power) {
        this.mPlayer.setPower(Double.valueOf(power));
    }

    @Override
    public double getMaximumPower() {
        return this.mPlayer.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.mPlayer.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.mPlayer.setPowerBoost(Double.valueOf(powerBoost));
    }
}

