/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Peaceful State of Faction")
@Description(value={"Gets whether a faction is peaceful or not"})
@Examples(value={"if peaceful state of player's faction is true:", "\tsend \"Your faction is pretty tranquil, if I have to say..\""})
public class ExprPeacefulStateOfFaction
extends SimplePropertyExpression<ConquerFaction, Boolean> {
    protected String getPropertyName() {
        return "peaceful state";
    }

    public Boolean convert(ConquerFaction conquerFaction) {
        return conquerFaction.isPeaceful();
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Boolean.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        boolean peaceful = (Boolean)delta[0];
        for (ConquerFaction faction : (ConquerFaction[])this.getExpr().getArray(e)) {
            faction.setPeaceful(peaceful);
        }
    }

    static {
        ExprPeacefulStateOfFaction.register(ExprPeacefulStateOfFaction.class, Boolean.class, (String)"[the] peaceful [(state|flag)][s]", (String)"conquerfaction");
    }
}

