/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Faction of Player")
@Description(value={"Gets the faction of a player"})
@Examples(value={"if faction of player is not set:", "\tsend \"What the freak, join a faction you noob.\""})
public class ExprFactionOfPlayer
extends SimplePropertyExpression<ConquerPlayer, ConquerFaction> {
    protected String getPropertyName() {
        return "faction";
    }

    public ConquerFaction convert(ConquerPlayer conquerPlayer) {
        return conquerPlayer.getFaction();
    }

    public Class<? extends ConquerFaction> getReturnType() {
        return ConquerFaction.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{ConquerFaction.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerPlayer[] players = (ConquerPlayer[])this.getExpr().getArray(e);
        if (players == null) {
            return;
        }
        ConquerFaction faction = null;
        if (mode == Changer.ChangeMode.SET) {
            if (delta == null || delta.length == 0) {
                return;
            }
            faction = (ConquerFaction)delta[0];
        }
        for (ConquerPlayer player : players) {
            if (player == null) continue;
            player.setFaction(faction);
        }
    }

    static {
        ExprFactionOfPlayer.register(ExprFactionOfPlayer.class, ConquerFaction.class, (String)"[the] [current] faction", (String)"conquerplayers");
    }
}

