/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Claim for Faction")
@Description(value={"Claim land for a faction"})
@Examples(value={"claim the land at player's location for player's faction"})
public class EffChangeClaimOwnership
extends Effect {
    private boolean claiming;
    private Expression<Object> claims;
    private boolean forFactions;
    private Expression<Object> type;

    protected void execute(Event e) {
        Object[] claimObjects = this.claims.getArray(e);
        if (claimObjects == null) {
            return;
        }
        ArrayList claims = new ArrayList();
        for (Object claimObject : claimObjects) {
            if (claimObject instanceof ConquerClaim) {
                claims.add((ConquerClaim)claimObject);
                continue;
            }
            if (!(claimObject instanceof Location)) continue;
            claims.add(Conquer.getInstance().getFactions().getClaim((Location)claimObject));
        }
        if (this.claiming) {
            if (this.forFactions) {
                ConquerFaction faction = (ConquerFaction)this.type.getSingle(e);
                if (faction == null) {
                    return;
                }
                claims.forEach(faction::claim);
            } else {
                ClaimType type = (ClaimType)((Object)this.type.getSingle(e));
                if (type == null) {
                    return;
                }
                claims.forEach(claim -> claim.setTo(type));
            }
        } else {
            claims.forEach(claim -> claim.setTo(ClaimType.WILDERNESS));
        }
    }

    public String toString(Event e, boolean debug) {
        return this.claiming ? "claim " + this.claims.toString(e, debug) + " for " + this.type.toString(e, debug) : "unclaim " + this.claims.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.claiming = matchedPattern == 0 || matchedPattern == 1;
        this.forFactions = matchedPattern == 0;
        this.claims = exprs[0];
        this.type = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffChangeClaimOwnership.class, (String[])new String[]{"claim [the] [(land|claim|chunk)][s] [at] %conquerclaims/locations% for [the] [faction][s] %conquerfaction%", "claim [the] [(land|claim|chunk)][s] [at] %conquerclaims/locations% for [the] %claimtype%", "unclaim [the] [(land|claim|chunk)][s] [at] %conquerclaims/locations%"});
    }
}

