/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.andrew28.addons.conquer.api.PowerHolder;
import org.bukkit.event.Event;

@Name(value="Normal/Maximum/Boosting Power")
@Description(value={"The normal/maximum/boosting power of a faction or player"})
@Examples(value={"set the power of the player to the player's maximum power"})
public class ExprPower
extends SimplePropertyExpression<PowerHolder, Double> {
    private int mark;

    protected String getPropertyName() {
        switch (this.mark) {
            case 1: {
                return "power";
            }
            case 2: {
                return "maximum power";
            }
            case 3: {
                return "power boost";
            }
        }
        return null;
    }

    public Double convert(PowerHolder powerHolder) {
        if (powerHolder == null) {
            return null;
        }
        switch (this.mark) {
            case 1: {
                return powerHolder.getPower();
            }
            case 2: {
                return powerHolder.getMaximumPower();
            }
            case 3: {
                return powerHolder.getPowerBoost();
            }
        }
        return null;
    }

    public Class<? extends Double> getReturnType() {
        return Double.class;
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.mark = parseResult.mark;
        return super.init(exprs, matchedPattern, isDelayed, parseResult);
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (this.mark == 1 || this.mark == 3) {
            return new Class[]{Double.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Double amount;
        if (mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.REMOVE_ALL) {
            amount = 0.0;
        } else {
            if (delta == null || delta.length == 0) {
                return;
            }
            amount = delta[0] == null ? 0.0 : (Double)delta[0];
        }
        PowerHolder powerHolder = (PowerHolder)this.getExpr().getSingle(e);
        if (powerHolder == null) {
            return;
        }
        switch (this.mark) {
            case 1: {
                powerHolder.setPower(amount);
                break;
            }
            case 3: {
                powerHolder.setPowerBoost(amount);
            }
        }
    }

    static {
        ExprPower.register(ExprPower.class, Double.class, (String)"[the] (1\u00c2\u00a6power|2\u00c2\u00a6max[imum] power|3\u00c2\u00a6power [boost][er])", (String)"powerholders");
    }
}

