/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Examples;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import ch.njol.skript.util.Date;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Home of Faction")
@Description(value={"The home location of a faction"})
@Examples(value={"teleport the player to home of player's faction"})
public class ExprHomeOfFaction
extends SimplePropertyExpression<ConquerFaction, Location> {
    protected String getPropertyName() {
        return "creation date";
    }

    public Location convert(ConquerFaction faction) {
        return faction.getHome();
    }

    public Class<? extends Location> getReturnType() {
        return Location.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Date.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        ConquerFaction faction = (ConquerFaction)this.getExpr().getSingle(e);
        if (faction == null) {
            return;
        }
        faction.setHome((Location)delta[0]);
    }

    static {
        ExprHomeOfFaction.register(ExprHomeOfFaction.class, Location.class, (String)"[the] home [location]", (String)"conquerfactions");
    }
}

