/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Converter;
import ch.njol.skript.classes.EnumSerializer;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.lang.ParseContext;
import ch.njol.skript.registrations.Classes;
import ch.njol.skript.registrations.Converters;
import ch.njol.skript.util.Getter;
import ch.njol.skript.util.StringMode;
import ch.njol.yggdrasil.Fields;
import java.io.StreamCorruptedException;
import java.util.UUID;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import me.andrew28.addons.conquer.api.PowerHolder;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.util.EnumParser;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Types {
    static {
        final FactionsPlugin factionsPlugin = Conquer.getInstance().getFactions();
        Classes.registerClass((ClassInfo)new ClassInfo(ConquerClaim.class, "conquerclaim").user(new String[]{"(conquer|faction)?claims?"}).name("Conquer Claim").description(new String[]{"Represents a claim (usually a chunk) which can be owned by the wilderness, a safe zone, a war zone, or even a faction."}).examples(new String[]{"set {_claim} to claim at player"}).usage(new String[]{"claim at %location/chunk%"}).parser((Parser)new Parser<ConquerClaim>(){

            public String toString(ConquerClaim o, int flags) {
                return Classes.toString(o.getRepresentation());
            }

            public ConquerClaim parse(String s, ParseContext context) {
                return null;
            }

            public String toVariableNameString(ConquerClaim o) {
                return Classes.toString(o.getRepresentation(), (StringMode)StringMode.VARIABLE_NAME);
            }

            public String getVariableNamePattern() {
                return ".*";
            }
        }).serializer((Serializer)new Serializer<ConquerClaim>(){

            public Fields serialize(ConquerClaim o) {
                return o.serialize();
            }

            protected ConquerClaim deserialize(Fields fields) throws StreamCorruptedException {
                return factionsPlugin.deserializeClaim(fields);
            }

            public void deserialize(ConquerClaim o, Fields f) {
                throw new UnsupportedOperationException();
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }).changer((Changer)new Changer<ConquerClaim>(){

            public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET) {
                    return new Class[]{ClaimType.class};
                }
                return null;
            }

            public void change(ConquerClaim[] claims, Object[] delta, Changer.ChangeMode mode) {
                ClaimType type = ClaimType.WILDERNESS;
                if (mode == Changer.ChangeMode.SET) {
                    if (delta == null || delta.length == 0) {
                        return;
                    }
                    type = (ClaimType)((Object)delta[0]);
                    if (type == null) {
                        type = ClaimType.WILDERNESS;
                    }
                }
                for (ConquerClaim claim : claims) {
                    if (claim == null) continue;
                    claim.setTo(type);
                }
            }
        }));
        if (factionsPlugin.getClaimRepresentationClass().equals(Chunk.class)) {
            Converters.registerConverter(Chunk.class, ConquerClaim.class, chunk -> {
                Location location = new Location(chunk.getWorld(), (double)(chunk.getX() * 16), 0.0, (double)(chunk.getZ() * 16));
                return factionsPlugin.getClaim(location);
            });
            Converters.registerConverter(ConquerClaim.class, Chunk.class, claim -> (Chunk)claim.getRepresentation());
        }
        Converters.registerConverter(Location.class, ConquerClaim.class, factionsPlugin::getClaim);
        Classes.registerClass((ClassInfo)new ClassInfo(ConquerFaction.class, "conquerfaction").user(new String[]{"(conquer)?factions?"}).name("Conquer Faction").description(new String[]{"Represents a faction"}).examples(new String[]{"set {_faction} to faction of player"}).usage(new String[]{"faction of %player%"}).parser((Parser)new Parser<ConquerFaction>(){

            public String toString(ConquerFaction o, int flags) {
                return o.getName();
            }

            public ConquerFaction parse(String s, ParseContext context) {
                return factionsPlugin.getFactionResolver().getByName(s);
            }

            public String toVariableNameString(ConquerFaction o) {
                return o.getName();
            }

            public String getVariableNamePattern() {
                return ".*";
            }
        }).serializer((Serializer)new Serializer<ConquerFaction>(){

            public Fields serialize(ConquerFaction o) {
                return o.serialize();
            }

            protected ConquerFaction deserialize(Fields fields) throws StreamCorruptedException {
                return factionsPlugin.deserializeFaction(fields);
            }

            public void deserialize(ConquerFaction o, Fields f) {
                throw new UnsupportedOperationException();
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }
        }).changer((Changer)new Changer<ConquerFaction>(){

            public Class<?>[] acceptChange(Changer.ChangeMode mode) {
                if (mode == Changer.ChangeMode.DELETE || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET) {
                    return new Class[0];
                }
                return null;
            }

            public void change(ConquerFaction[] factions, Object[] delta, Changer.ChangeMode mode) {
                for (ConquerFaction faction : factions) {
                    if (faction == null) continue;
                    faction.disband();
                }
            }
        }));
        Classes.registerClass((ClassInfo)new ClassInfo(ConquerPlayer.class, "conquerplayer").user(new String[]{"(conquer|faction)?-?players?"}).name("Conquer Player").description(new String[]{"Represents a faction player. An offline player/player will be automatically converted to this type. So normal players will work in all faction syntaxes"}).examples(new String[]{"set {_faction} to faction of player #syntax is faction of %conquerplayer%"}).usage(new String[]{"%offlineplayer/player%"}).parser((Parser)new Parser<ConquerPlayer>(){

            public String toString(ConquerPlayer o, int flags) {
                return o.getName();
            }

            public ConquerPlayer parse(String s, ParseContext context) {
                return null;
            }

            public String toVariableNameString(ConquerPlayer o) {
                return this.toString(o, 0);
            }

            public String getVariableNamePattern() {
                return ".*";
            }
        }));
        Converters.registerConverter(OfflinePlayer.class, ConquerPlayer.class, factionsPlugin::getConquerPlayer);
        Converters.registerConverter(String.class, ConquerPlayer.class, (Converter)new Getter<ConquerPlayer, String>(){

            public ConquerPlayer get(String arg) {
                OfflinePlayer player = Bukkit.getOfflinePlayer((String)arg);
                if (player == null && arg.split("-").length == 5) {
                    player = Bukkit.getOfflinePlayer((UUID)UUID.fromString(arg));
                }
                if (player == null) {
                    return null;
                }
                return factionsPlugin.getConquerPlayer(player);
            }
        });
        Converters.registerConverter(ConquerPlayer.class, OfflinePlayer.class, ConquerPlayer::getOfflinePlayer);
        Converters.registerConverter(OfflinePlayer.class, ConquerPlayer.class, factionsPlugin::getConquerPlayer);
        Converters.registerConverter(ConquerPlayer.class, Player.class, conquerPlayer -> {
            OfflinePlayer offlinePlayer = conquerPlayer.getOfflinePlayer();
            if (offlinePlayer instanceof Player) {
                return (Player)offlinePlayer;
            }
            return null;
        });
        Classes.registerClass((ClassInfo)new ClassInfo(PowerHolder.class, "powerholder").user(new String[]{"(conquer|faction)?-?powerholders?"}).name("Power Holder").description(new String[]{"Represents something that holds power, this is a faction or a player."}).examples(new String[]{"set {_playerPower} to power of player", "set {_factionPower} to power of player's faction", "send \"You make up %({_playerPower} / {_factionPower}) * 100%%% of your faction's power\""}).usage(new String[]{"%conquerfaction/conquerplayer%"}));
        Classes.registerClass((ClassInfo)new ClassInfo(Relation.class, "factionrelation").user(new String[]{"(conquer|faction)?-?relations?"}).name("Faction Relation").description(new String[]{"Represents a relation that factions have been two people"}).examples(new String[]{"on death of player", "\tif relation between victim's faction and attacker's faction is enemy:", "\t\tsubtract 100 from victim's balance"}).usage(new String[]{"member, ally, truce, neutral, enemy, other"}).parser(new EnumParser<Relation>(Relation.class)).serializer((Serializer)new EnumSerializer(Relation.class)));
        Converters.registerConverter(ConquerFaction.class, CommandSender.class, ConquerFaction::getSender);
        Classes.registerClass((ClassInfo)new ClassInfo(ConquerPlayer.Role.class, "conquerrole").user(new String[]{"(conquer|faction)?-?roles?"}).name("Player Role").description(new String[]{"Represents a role that a player may hold"}).usage(new String[]{"normal, admin, moderator, recruit, other"}).parser(new EnumParser<ConquerPlayer.Role>(ConquerPlayer.Role.class)).serializer((Serializer)new EnumSerializer(ConquerPlayer.Role.class)));
        Classes.registerClass((ClassInfo)new ClassInfo(ClaimType.class, "claimtype").user(new String[]{"(conquer)?claim-?types?"}).name("Claim Type").description(new String[]{"Represents who claimed a type"}).usage(new String[]{"wilderness, safe zone, war zone, faction"}).parser(new EnumParser<ClaimType>(ClaimType.class)).serializer((Serializer)new EnumSerializer(ClaimType.class)));
    }
}

