/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.mfactions;

import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.RelationParticipator;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.factions.entity.Invitation;
import com.massivecraft.factions.entity.MFlag;
import com.massivecraft.factions.entity.MPlayer;
import com.massivecraft.factions.entity.MPlayerColl;
import com.massivecraft.massivecore.store.EntityInternal;
import com.massivecraft.massivecore.store.EntityInternalMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.Relation;
import me.andrew28.addons.conquer.api.sender.MessageOnlySender;
import me.andrew28.addons.conquer.impl.mfactions.MSClaim;
import me.andrew28.addons.conquer.impl.mfactions.MSPlayer;
import me.andrew28.addons.conquer.impl.mfactions.MSPlugin;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class MSFaction
extends ConquerFaction {
    private static Method setIdMethod;
    private static WeakHashMap<Faction, MSFaction> cache;
    private MSPlugin plugin;
    private FactionColl factionColl;
    private MPlayerColl mPlayerColl;
    private BoardColl boardColl;
    private Faction faction;
    private CommandSender sender;

    private MSFaction(MSPlugin plugin, Faction faction) {
        this.plugin = plugin;
        this.factionColl = plugin.getFactionColl();
        this.mPlayerColl = plugin.getmPlayerColl();
        this.boardColl = plugin.getBoardColl();
        this.faction = faction;
    }

    public static MSFaction get(MSPlugin plugin, Faction faction) {
        if (faction == null || !faction.isNormal() || faction.getId().equals("safezone") || faction.getId().equals("warzone")) {
            return null;
        }
        if (!cache.containsKey(faction)) {
            MSFaction msFaction = new MSFaction(plugin, faction);
            cache.put(faction, msFaction);
            return msFaction;
        }
        return cache.get(faction);
    }

    @Override
    public String getId() {
        return this.faction.getId();
    }

    @Override
    public void setId(String id) {
        try {
            setIdMethod.invoke((Object)this.faction, id);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getName() {
        return this.faction.getName();
    }

    @Override
    public void setName(String name) {
        this.faction.setName(name);
    }

    @Override
    public String getDescription() {
        return this.faction.getDescription();
    }

    @Override
    public void setDescription(String description) {
        this.faction.setDescription(description);
    }

    @Override
    public String getMotd() {
        return this.faction.getMotd();
    }

    @Override
    public void setMotd(String motd) {
        this.faction.setMotd(motd);
    }

    @Override
    public Date getCreationDate() {
        return new Date(this.faction.getCreatedAtMillis());
    }

    @Override
    public void setCreationDate(Date date) {
        this.faction.setCreatedAtMillis(date.getTime());
    }

    @Override
    public double getPower() {
        return this.faction.getPower();
    }

    @Override
    public void setPower(double power) {
    }

    @Override
    public double getMaximumPower() {
        return this.faction.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.faction.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.faction.setPowerBoost(Double.valueOf(powerBoost));
    }

    @Override
    public ConquerPlayer getLeader() {
        return MSPlayer.get(this.plugin, this.faction.getLeader());
    }

    @Override
    public void setLeader(ConquerPlayer leader) {
        leader.setRole(ConquerPlayer.Role.ADMIN);
    }

    @Override
    public Location getHome() {
        return this.plugin.translate(this.faction.getHome());
    }

    @Override
    public void setHome(Location home) {
        this.faction.setHome(this.plugin.translate(home));
    }

    @Override
    public ConquerPlayer[] getMembers() {
        return (ConquerPlayer[])this.faction.getMPlayers().stream().map(mPlayer -> MSPlayer.get(this.plugin, mPlayer)).toArray(ConquerPlayer[]::new);
    }

    @Override
    public void addMember(ConquerPlayer member) {
        ((MSPlayer)member).getRawPlayer().setFaction(this.faction);
    }

    @Override
    public void removeMember(ConquerPlayer member) {
        ((MSPlayer)member).getRawPlayer().setFaction(this.factionColl.getNone());
    }

    @Override
    public CommandSender getSender() {
        if (this.sender == null) {
            this.sender = new MessageOnlySender(){

                public void sendMessage(String message) {
                    MSFaction.this.faction.sendMessage((Object)message);
                }

                @Override
                public void sendMessage(String[] messages) {
                    MSFaction.this.faction.sendMessage((Object[])messages);
                }
            };
        }
        return this.sender;
    }

    @Override
    public Map<String, Location> getWarps() {
        return null;
    }

    @Override
    public boolean hasWarpPassword(String warp) {
        return false;
    }

    @Override
    public boolean isWarpPassword(String warp, String password) {
        return false;
    }

    @Override
    public String getWarpPassword(String warp) {
        return null;
    }

    @Override
    public void setWarpPassword(String warp, String password) {
    }

    @Override
    public Set<ConquerPlayer> getInvited() {
        EntityInternalMap invitations = this.faction.getInvitations();
        if (invitations == null) {
            return Collections.emptySet();
        }
        return invitations.entrySet().stream().map(entry -> (MPlayer)this.mPlayerColl.get(entry.getKey())).filter(Objects::nonNull).map(mPlayer -> MSPlayer.get(this.plugin, mPlayer)).collect(Collectors.toSet());
    }

    @Override
    public void invite(ConquerPlayer player) {
        MPlayer mPlayer = ((MSPlayer)player).getRawPlayer();
        Invitation invitation = new Invitation("@console", Long.valueOf(System.currentTimeMillis()));
        this.faction.invite(mPlayer.getId(), invitation);
    }

    @Override
    public void deinvite(ConquerPlayer player) {
        this.faction.uninvite(((MSPlayer)player).getRawPlayer());
    }

    @Override
    public boolean isPeaceful() {
        return this.faction.getFlag(MFlag.getFlagPeaceful());
    }

    @Override
    public void setPeaceful(boolean peaceful) {
        this.faction.setFlag(MFlag.getFlagPeaceful(), peaceful);
    }

    @Override
    public boolean isOpen() {
        return this.faction.getFlag(MFlag.getFlagOpen());
    }

    @Override
    public void setOpen(boolean open) {
        this.faction.setFlag(MFlag.getFlagOpen(), open);
    }

    @Override
    public Relation getRelationTo(ConquerFaction faction) {
        return this.plugin.translateRelation(this.faction.getRelationTo((RelationParticipator)((MSFaction)faction).getRawFaction()));
    }

    @Override
    public void setRelationBetween(ConquerFaction faction, Relation relation) {
        this.faction.setRelationWish(((MSFaction)faction).getRawFaction(), this.plugin.translateRelation(relation));
    }

    @Override
    public ConquerClaim<?>[] getClaims() {
        return (ConquerClaim[])this.boardColl.getChunks(this.faction).stream().map(ps -> MSClaim.get(this.plugin, ps)).toArray(ConquerClaim[]::new);
    }

    @Override
    public void claim(ConquerClaim<?> claim) {
        this.boardColl.setFactionAt(((MSClaim)claim).getRawPS(), this.faction);
    }

    @Override
    public void claim(Location location) {
        this.boardColl.setFactionAt(this.plugin.translate(location), this.faction);
    }

    @Override
    public void unclaim(ConquerClaim<?> claim) {
        this.boardColl.setFactionAt(((MSClaim)claim).getRawPS(), this.factionColl.getNone());
    }

    @Override
    public void unclaim(Location location) {
        this.boardColl.setFactionAt(this.plugin.translate(location), this.factionColl.getNone());
    }

    @Override
    public void disband() {
        this.faction.detach();
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("id", (Object)this.faction.getId());
        return fields;
    }

    public Faction getRawFaction() {
        return this.faction;
    }

    static {
        try {
            setIdMethod = EntityInternal.class.getDeclaredMethod("setId", String.class);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        cache = new WeakHashMap();
    }
}

