/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Claims of Faction")
@Description(value={"The claims of a faction"})
public class ExprClaimsOfFaction
extends SimpleExpression<ConquerClaim> {
    private Expression<ConquerFaction> factions;

    protected ConquerClaim[] get(Event e) {
        ConquerFaction[] factions;
        ArrayList claims = new ArrayList();
        for (ConquerFaction faction : factions = (ConquerFaction[])this.factions.getArray(e)) {
            if (faction == null) continue;
            claims.addAll(Arrays.asList(faction.getClaims()));
        }
        return claims.toArray(new ConquerClaim[claims.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends ConquerClaim> getReturnType() {
        return ConquerClaim.class;
    }

    public String toString(Event e, boolean debug) {
        return "claims of " + this.factions.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.factions = exprs[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{ConquerClaim[].class};
        }
        if (mode == Changer.ChangeMode.ADD || mode == Changer.ChangeMode.REMOVE || mode == Changer.ChangeMode.REMOVE_ALL || mode == Changer.ChangeMode.RESET || mode == Changer.ChangeMode.DELETE) {
            return new Class[]{ConquerClaim.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerFaction[] factions = (ConquerFaction[])this.factions.getArray(e);
        if (factions == null) {
            return;
        }
        switch (mode) {
            case SET: {
                if (delta == null) {
                    return;
                }
                List<Object> claims = Arrays.asList(delta);
                for (ConquerFaction faction : factions) {
                    if (faction == null) {
                        return;
                    }
                    List<ConquerClaim<?>> currentClaims = Arrays.asList(faction.getClaims());
                    for (ConquerClaim conquerClaim : claims) {
                        if (currentClaims.contains(conquerClaim)) continue;
                        faction.claim(conquerClaim);
                    }
                    for (ConquerClaim<?> claim : faction.getClaims()) {
                        if (claims.contains(claim)) continue;
                        faction.unclaim(claim);
                    }
                }
                break;
            }
            case ADD: 
            case REMOVE: {
                if (delta == null || delta.length == 0 || delta[0] == null) {
                    return;
                }
                ConquerClaim claim = (ConquerClaim)delta[0];
                for (ConquerFaction faction : factions) {
                    if (mode == Changer.ChangeMode.ADD) {
                        faction.claim(claim);
                        continue;
                    }
                    faction.unclaim(claim);
                }
                break;
            }
            case REMOVE_ALL: 
            case DELETE: 
            case RESET: {
                for (ConquerFaction faction : factions) {
                    for (ConquerClaim<?> claim : faction.getClaims()) {
                        faction.unclaim(claim);
                    }
                }
                break;
            }
        }
    }

    static {
        Skript.registerExpression(ExprClaimsOfFaction.class, ConquerClaim.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[all] [of] [the] claim[s] of %conquerfactions%", "%conquerfactions%'s claim[s]"});
    }
}

