/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.effects;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Effect;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Invite/Deinvite Player From a Faction")
@Description(value={"Invite/Deinvite a player from a faction"})
public class EffInvitePlayer
extends Effect {
    private boolean invite;
    private Expression<ConquerPlayer> players;
    private Expression<ConquerFaction> factions;

    protected void execute(Event e) {
        ConquerPlayer[] players = (ConquerPlayer[])this.players.getArray(e);
        ConquerFaction[] factions = (ConquerFaction[])this.factions.getArray(e);
        if (players == null || factions == null) {
            return;
        }
        for (ConquerPlayer player : players) {
            if (player == null) continue;
            for (ConquerFaction faction : factions) {
                if (faction == null) continue;
                if (this.invite) {
                    faction.invite(player);
                    continue;
                }
                faction.deinvite(player);
            }
        }
    }

    public String toString(Event e, boolean debug) {
        return (this.invite ? "invite" : "deinvite") + " " + this.players.toString(e, debug) + " " + (this.invite ? "to" : "from") + "  the faction" + (this.factions.isSingle() ? "" : "s") + this.factions.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.invite = parseResult.mark == 0;
        this.players = exprs[0];
        this.factions = exprs[1];
        return true;
    }

    static {
        Skript.registerEffect(EffInvitePlayer.class, (String[])new String[]{"[(1\u00c2\u00a6de)]invite [the] [player][s] %conquerplayers% (to|from) [the] [faction][s] %conquerfactions%"});
    }
}

