/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Faction Warp Password Is Valid")
@Description(value={"Whether a password is valid for a warp of a faction"})
public class CondWarpPassValid
extends Condition {
    private Expression<String> password;
    private Expression<String> names;
    private Expression<ConquerFaction> faction;

    public boolean check(Event e) {
        String password = (String)this.password.getSingle(e);
        ConquerFaction faction = (ConquerFaction)this.faction.getSingle(e);
        return password != null && faction != null && this.names.check(e, warp -> faction.isWarpPassword((String)warp, password), this.isNegated());
    }

    public String toString(Event e, boolean debug) {
        return "password " + this.password.toString(e, debug) + " " + (this.isNegated() ? "is" : "isn't") + " valid for the warp " + (this.names.isSingle() ? "" : "s") + "of faction " + this.faction.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.password = exprs[0];
        this.names = exprs[1];
        this.faction = exprs[2];
        this.setNegated(parseResult.mark == 1);
        return true;
    }

    static {
        Skript.registerCondition(CondWarpPassValid.class, (String[])new String[]{"[the] [password] %string% (is|1\u00c2\u00a6is(n't| not)) (valid|correct) [for] [the] [warp][s] %strings% (of|for) [the] [faction] %conquerfaction%"});
    }
}

