/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.mfactions;

import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.entity.BoardColl;
import com.massivecraft.factions.entity.Faction;
import com.massivecraft.factions.entity.FactionColl;
import com.massivecraft.massivecore.ps.PS;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.impl.mfactions.MSPlugin;
import org.bukkit.Chunk;

public class MSClaim
extends ConquerClaim<Chunk> {
    private static WeakHashMap<Object, MSClaim> cache = new WeakHashMap();
    private Chunk chunk;
    private FactionColl factionColl;
    private BoardColl boardColl;
    private PS ps;

    private MSClaim(MSPlugin plugin, PS ps) {
        this.chunk = ps.asBukkitChunk();
        this.factionColl = plugin.getFactionColl();
        this.boardColl = plugin.getBoardColl();
        this.ps = ps;
    }

    private MSClaim(MSPlugin plugin, Chunk chunk) {
        this.chunk = chunk;
        this.factionColl = plugin.getFactionColl();
        this.boardColl = plugin.getBoardColl();
        this.ps = PS.valueOf((Chunk)chunk);
    }

    public static MSClaim get(MSPlugin plugin, PS ps) {
        if (ps == null) {
            return null;
        }
        if (!cache.containsKey(ps)) {
            MSClaim msClaim = new MSClaim(plugin, ps);
            cache.put(ps, msClaim);
            return msClaim;
        }
        return cache.get(ps);
    }

    public static MSClaim get(MSPlugin plugin, Chunk chunk) {
        if (chunk == null) {
            return null;
        }
        if (!cache.containsKey(chunk)) {
            MSClaim msClaim = new MSClaim(plugin, chunk);
            cache.put(chunk, msClaim);
            return msClaim;
        }
        return cache.get(chunk);
    }

    @Override
    public Chunk getRepresentation() {
        return this.chunk;
    }

    @Override
    public ClaimType getType() {
        Faction faction = this.boardColl.getFactionAt(this.ps);
        if (faction.isNone()) {
            return ClaimType.WILDERNESS;
        }
        if (faction.getId().equals(this.factionColl.getSafezone().getId())) {
            return ClaimType.SAFE_ZONE;
        }
        if (faction.getId().endsWith(this.factionColl.getWarzone().getId())) {
            return ClaimType.WAR_ZONE;
        }
        return ClaimType.FACTION;
    }

    @Override
    public void setTo(ClaimType type) {
        Faction faction;
        switch (type) {
            case WILDERNESS: {
                faction = this.factionColl.getNone();
                break;
            }
            case SAFE_ZONE: {
                faction = this.factionColl.getSafezone();
                break;
            }
            case WAR_ZONE: {
                faction = this.factionColl.getWarzone();
                break;
            }
            default: {
                return;
            }
        }
        this.boardColl.setFactionAt(this.ps, faction);
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("chunk", (Object)this.chunk);
        return fields;
    }

    public PS getRawPS() {
        return this.ps;
    }
}

