/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.factionsuuid;

import com.massivecraft.factions.FPlayer;
import com.massivecraft.factions.Factions;
import java.util.Date;
import java.util.UUID;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import me.andrew28.addons.conquer.api.sender.AllPermissionsSender;
import me.andrew28.addons.conquer.impl.factionsuuid.FUFaction;
import me.andrew28.addons.conquer.impl.factionsuuid.FUPlugin;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class FUPlayer
extends ConquerPlayer {
    private static WeakHashMap<Object, FUPlayer> cache = new WeakHashMap();
    private FUPlugin plugin;
    private Factions factions;
    private FPlayer fPlayer;
    private OfflinePlayer offlinePlayer;

    private FUPlayer(FUPlugin plugin, FPlayer fPlayer) {
        this.plugin = plugin;
        this.factions = plugin.getFactions();
        this.fPlayer = fPlayer;
        this.offlinePlayer = Bukkit.getOfflinePlayer((UUID)UUID.fromString(fPlayer.getId()));
    }

    private FUPlayer(FUPlugin plugin, OfflinePlayer player) {
        this.plugin = plugin;
        this.offlinePlayer = player;
        this.fPlayer = player instanceof Player ? plugin.getfPlayers().getByPlayer((Player)player) : plugin.getfPlayers().getByOfflinePlayer(player);
    }

    public static FUPlayer get(FUPlugin plugin, FPlayer fPlayer) {
        if (fPlayer == null) {
            return null;
        }
        if (!cache.containsKey(fPlayer)) {
            FUPlayer fuPlayer = new FUPlayer(plugin, fPlayer);
            cache.put(fPlayer, fuPlayer);
            return fuPlayer;
        }
        return cache.get(fPlayer);
    }

    public static FUPlayer get(FUPlugin plugin, OfflinePlayer player) {
        if (player == null) {
            return null;
        }
        if (!cache.containsKey(player)) {
            FUPlayer fuPlayer = new FUPlayer(plugin, player);
            cache.put(player, fuPlayer);
            return fuPlayer;
        }
        return cache.get(player);
    }

    @Override
    public String getName() {
        return this.offlinePlayer.getName();
    }

    @Override
    public boolean hasFaction() {
        return this.fPlayer.getFaction().isNormal();
    }

    @Override
    public ConquerFaction getFaction() {
        return FUFaction.get(this.plugin, this.fPlayer.getFaction());
    }

    @Override
    public void setFaction(ConquerFaction faction) {
        this.fPlayer.setFaction(faction == null ? this.factions.getWilderness() : ((FUFaction)faction).getRawFaction());
    }

    @Override
    public boolean isAutoClaiming() {
        return this.fPlayer.getAutoClaimFor() != null;
    }

    @Override
    public void setAutoClaiming(boolean autoClaiming) {
        this.fPlayer.setAutoClaimFor(this.fPlayer.getFaction());
    }

    @Override
    public Date getLastActivity() {
        return new Date(this.fPlayer.getLastLoginTime());
    }

    @Override
    public void setLastActivity(Date date) {
        this.fPlayer.setLastFrostwalkerMessage();
    }

    @Override
    public ConquerPlayer.Role getRole() {
        return this.plugin.translate(this.fPlayer.getRole());
    }

    @Override
    public void setRole(ConquerPlayer.Role role) {
        this.fPlayer.setRole(this.plugin.translate(role));
    }

    @Override
    public String getTitle() {
        return this.fPlayer.getTitle();
    }

    @Override
    public void setTitle(String title) {
        this.fPlayer.setTitle((CommandSender)new AllPermissionsSender(), title);
    }

    @Override
    public void leaveFaction() {
        this.fPlayer.leave(false);
    }

    @Override
    public OfflinePlayer getOfflinePlayer() {
        return this.offlinePlayer;
    }

    public FPlayer getRawPlayer() {
        return this.fPlayer;
    }

    @Override
    public double getPower() {
        return this.fPlayer.getPower();
    }

    @Override
    public void setPower(double power) {
        this.fPlayer.alterPower(power - this.getPower());
    }

    @Override
    public double getMaximumPower() {
        return this.fPlayer.getPowerMax();
    }

    @Override
    public double getPowerBoost() {
        return this.fPlayer.getPowerBoost();
    }

    @Override
    public void setPowerBoost(double powerBoost) {
        this.fPlayer.setPowerBoost(powerBoost);
    }
}

