/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.impl.factionsuuid;

import ch.njol.yggdrasil.Fields;
import com.massivecraft.factions.Board;
import com.massivecraft.factions.FLocation;
import com.massivecraft.factions.Faction;
import com.massivecraft.factions.Factions;
import java.util.WeakHashMap;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.impl.factionsuuid.FUPlugin;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;

public class FUClaim
extends ConquerClaim<Chunk> {
    private static WeakHashMap<Object, FUClaim> cache = new WeakHashMap();
    private Chunk chunk;
    private Factions factions;
    private Board board;
    private FLocation fLocation;

    private FUClaim(FUPlugin plugin, FLocation fLocation) {
        this.chunk = Bukkit.getWorld((String)fLocation.getWorldName()).getChunkAt(Math.toIntExact(fLocation.getX()), Math.toIntExact(fLocation.getZ()));
        this.factions = plugin.getFactions();
        this.board = plugin.getBoard();
        this.fLocation = fLocation;
    }

    private FUClaim(FUPlugin plugin, Chunk chunk) {
        this.chunk = chunk;
        this.board = plugin.getBoard();
        this.fLocation = new FLocation(chunk.getWorld().getName(), chunk.getX(), chunk.getZ());
    }

    public static FUClaim get(FUPlugin plugin, FLocation fLocation) {
        if (fLocation == null) {
            return null;
        }
        if (!cache.containsKey(fLocation)) {
            FUClaim fuClaim = new FUClaim(plugin, fLocation);
            cache.put(fLocation, fuClaim);
            return fuClaim;
        }
        return cache.get(fLocation);
    }

    public static FUClaim get(FUPlugin plugin, Chunk chunk) {
        if (chunk == null) {
            return null;
        }
        if (!cache.containsKey(chunk)) {
            FUClaim fuClaim = new FUClaim(plugin, chunk);
            cache.put(chunk, fuClaim);
        }
        return cache.get(chunk);
    }

    @Override
    public Chunk getRepresentation() {
        return this.chunk;
    }

    @Override
    public ClaimType getType() {
        Faction faction = this.board.getFactionAt(this.fLocation);
        if (faction.isWilderness()) {
            return ClaimType.WILDERNESS;
        }
        if (faction.isSafeZone()) {
            return ClaimType.SAFE_ZONE;
        }
        if (faction.isWarZone()) {
            return ClaimType.WAR_ZONE;
        }
        return ClaimType.FACTION;
    }

    @Override
    public void setTo(ClaimType type) {
        Faction faction;
        switch (type) {
            case WILDERNESS: {
                faction = this.factions.getWilderness();
                break;
            }
            case SAFE_ZONE: {
                faction = this.factions.getSafeZone();
                break;
            }
            case WAR_ZONE: {
                faction = this.factions.getWarZone();
                break;
            }
            default: {
                return;
            }
        }
        this.board.setFactionAt(faction, this.fLocation);
    }

    @Override
    public Fields serialize() {
        Fields fields = new Fields();
        fields.putObject("chunk", (Object)this.chunk);
        return fields;
    }

    public FLocation getRawfLocation() {
        return this.fLocation;
    }
}

