/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Faction Title of Player")
@Description(value={"Gets the faction title of a player"})
public class ExprTitleOfPlayer
extends SimplePropertyExpression<ConquerPlayer, String> {
    protected String getPropertyName() {
        return "faction title";
    }

    public String convert(ConquerPlayer player) {
        return player.getTitle();
    }

    public Class<? extends String> getReturnType() {
        return String.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{String.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerPlayer[] players = (ConquerPlayer[])this.getExpr().getArray(e);
        if (players == null) {
            return;
        }
        String title = "";
        if (mode == Changer.ChangeMode.SET) {
            if (delta == null || delta.length == 0 || delta[0] == null) {
                return;
            }
            title = (String)delta[0];
        }
        for (ConquerPlayer player : players) {
            if (player == null) continue;
            player.setTitle(title);
        }
    }

    static {
        ExprTitleOfPlayer.register(ExprTitleOfPlayer.class, String.class, (String)"[the] [faction] title", (String)"conquerplayers");
    }
}

