/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Open State of Faction")
@Description(value={"Gets whether a faction is open or not"})
public class ExprOpenStateOfFaction
extends SimplePropertyExpression<ConquerFaction, Boolean> {
    protected String getPropertyName() {
        return "open state";
    }

    public Boolean convert(ConquerFaction conquerFaction) {
        return conquerFaction.isOpen();
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET) {
            return new Class[]{Boolean.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        if (delta == null || delta.length == 0 || delta[0] == null) {
            return;
        }
        boolean peaceful = (Boolean)delta[0];
        for (ConquerFaction faction : (ConquerFaction[])this.getExpr().getArray(e)) {
            faction.setOpen(peaceful);
        }
    }

    static {
        ExprOpenStateOfFaction.register(ExprOpenStateOfFaction.class, Boolean.class, (String)"[the] open [(state|flag)][s]", (String)"conquerfaction");
    }
}

