/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import java.util.HashSet;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.api.ClaimType;
import me.andrew28.addons.conquer.api.ConquerClaim;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.FactionResolver;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Faction at Location/Claim")
@Description(value={"Faction at location/claim"})
public class ExprFactionAtLocClaim
extends SimpleExpression<ConquerFaction> {
    private Expression<Object> targets;

    protected ConquerFaction[] get(Event e) {
        HashSet<ConquerFaction> factions = new HashSet<ConquerFaction>();
        FactionResolver factionResolver = Conquer.getInstance().getFactions().getFactionResolver();
        Object[] claimObjects = this.targets.getArray(e);
        if (claimObjects == null) {
            return null;
        }
        for (Object claimObject : claimObjects) {
            if (claimObject instanceof ConquerClaim) {
                factions.add(factionResolver.getByClaim((ConquerClaim)claimObject));
                continue;
            }
            if (!(claimObject instanceof Location)) continue;
            factions.add(factionResolver.getAtLocation((Location)claimObject));
        }
        return factions.toArray(new ConquerFaction[factions.size()]);
    }

    public boolean isSingle() {
        return false;
    }

    public Class<? extends ConquerFaction> getReturnType() {
        return ConquerFaction.class;
    }

    public String toString(Event e, boolean debug) {
        return "the faction" + (this.targets.isSingle() ? "" : "s") + " at " + this.targets.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.targets = exprs[0];
        return true;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.REMOVE_ALL) {
            return new Class[0];
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        Object[] claimObjects = this.targets.getArray(e);
        if (claimObjects == null) {
            return;
        }
        for (Object claimObject : claimObjects) {
            ConquerClaim<?> claim;
            if (claimObject == null) continue;
            if (claimObject instanceof ConquerClaim) {
                claim = (ConquerClaim<?>)claimObject;
            } else {
                if (!(claimObject instanceof Location)) continue;
                claim = Conquer.getInstance().getFactions().getClaim((Location)claimObject);
            }
            claim.setTo(ClaimType.WILDERNESS);
        }
    }

    static {
        Skript.registerExpression(ExprFactionAtLocClaim.class, ConquerFaction.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] faction[s] at %locations/conquerclaims%"});
    }
}

