/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.ExpressionType;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.skript.lang.util.SimpleExpression;
import ch.njol.util.Kleenean;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.api.ConquerClaim;
import org.bukkit.Location;
import org.bukkit.event.Event;

@Name(value="Claim At Location")
@Description(value={"The claim (usually represented by a chunk) at a location"})
public class ExprClaimAtLocation
extends SimpleExpression<ConquerClaim> {
    private Expression<Location> location;

    protected ConquerClaim<?>[] get(Event e) {
        Location location = (Location)this.location.getSingle(e);
        if (location == null) {
            return null;
        }
        return new ConquerClaim[]{Conquer.getInstance().getFactions().getClaim(location)};
    }

    public boolean isSingle() {
        return true;
    }

    public Class<? extends ConquerClaim> getReturnType() {
        return ConquerClaim.class;
    }

    public String toString(Event e, boolean debug) {
        return "claim at " + this.location.toString(e, debug);
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.location = exprs[0];
        return true;
    }

    static {
        Skript.registerExpression(ExprClaimAtLocation.class, ConquerClaim.class, (ExpressionType)ExpressionType.PROPERTY, (String[])new String[]{"[the] claim at %location%", "%location%'s claim"});
    }
}

