/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions;

import ch.njol.skript.classes.Changer;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.expressions.base.SimplePropertyExpression;
import me.andrew28.addons.conquer.api.ConquerPlayer;
import org.bukkit.event.Event;

@Name(value="Auto Claim State of Player")
@Description(value={"Gets whether a player is auto claiming"})
public class ExprAutoClaimState
extends SimplePropertyExpression<ConquerPlayer, Boolean> {
    protected String getPropertyName() {
        return "auto claim state";
    }

    public Boolean convert(ConquerPlayer player) {
        return player.isAutoClaiming();
    }

    public Class<? extends Boolean> getReturnType() {
        return Boolean.class;
    }

    public Class<?>[] acceptChange(Changer.ChangeMode mode) {
        if (mode == Changer.ChangeMode.SET || mode == Changer.ChangeMode.RESET) {
            return new Class[]{Boolean.class};
        }
        return null;
    }

    public void change(Event e, Object[] delta, Changer.ChangeMode mode) {
        ConquerPlayer[] players = (ConquerPlayer[])this.getExpr().getArray(e);
        boolean state = false;
        if (mode == Changer.ChangeMode.SET) {
            if (delta == null || delta.length == 0 || delta[0] == null) {
                return;
            }
            state = (Boolean)delta[0];
        }
        for (ConquerPlayer player : players) {
            if (player == null) continue;
            player.setAutoClaiming(state);
        }
    }

    static {
        ExprAutoClaimState.register(ExprAutoClaimState.class, Boolean.class, (String)"auto [chunk] claim[ing] [state]", (String)"conquerplayers");
    }
}

