/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Warp of Faction Has Password")
@Description(value={"Whether a warp of a faction has a password"})
public class CondWarpHasPass
extends Condition {
    private Expression<String> names;
    private Expression<ConquerFaction> faction;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean check(Event e) {
        ConquerFaction faction = (ConquerFaction)this.faction.getSingle(e);
        if (faction == null) return false;
        if (!this.names.check(e, faction::hasWarpPassword, this.isNegated())) return false;
        return true;
    }

    public String toString(Event e, boolean debug) {
        return "warp" + (this.names.isSingle() ? "" : "s") + " " + this.names.toString(e, debug) + " of " + this.faction.toString(e, debug) + (this.isNegated() ? "doesn't" : "does") + " use a password";
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.names = exprs[0];
        this.faction = exprs[1];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    static {
        Skript.registerCondition(CondWarpHasPass.class, (String[])new String[]{"[the] warp[s] [with] [name][s] %strings% (of|from) [the] [faction] %conquerfaction% (use[s]|ha(s|ve)) (a password|authentication)", "[the] warp[s] [with] [name][s] %strings% (of|from) [the] [faction] %conquerfaction% (doesn't| does not|don't|do not) (use|has) (a password|authentication)"});
    }
}

