/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="All Faction Players Online/Offline")
@Description(value={"Whether all players of a faction are online/offline"})
public class CondPlayersAreAllOnlineOffline
extends Condition {
    private Expression<ConquerFaction> factions;
    private boolean online;

    public boolean check(Event e) {
        return this.factions.check(e, faction -> Arrays.stream(faction.getMembers()).allMatch(player -> player.getOfflinePlayer().isOnline() == this.online), this.isNegated());
    }

    public String toString(Event e, boolean debug) {
        return "all players of the faction" + (this.factions.isSingle() ? "" : "s") + " are all " + (this.online ? "online" : "offline");
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.factions = exprs[0];
        this.online = parseResult.mark == 1;
        return true;
    }

    static {
        Skript.registerCondition(CondPlayersAreAllOnlineOffline.class, (String[])new String[]{"[all] [faction] players of [the] [faction][s] %conquerfactions% are [all] (1\u00c2\u00a6online|2\u00c2\u00a6offline)"});
    }
}

