/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.conditions;

import ch.njol.skript.Skript;
import ch.njol.skript.doc.Description;
import ch.njol.skript.doc.Name;
import ch.njol.skript.lang.Condition;
import ch.njol.skript.lang.Expression;
import ch.njol.skript.lang.SkriptParser;
import ch.njol.util.Kleenean;
import java.util.Arrays;
import me.andrew28.addons.conquer.api.ConquerFaction;
import org.bukkit.event.Event;

@Name(value="Any Faction Players Online/Offline")
@Description(value={"Whether any players of a faction are online/offline"})
public class CondAnyPlayersOnline
extends Condition {
    private Expression<ConquerFaction> factions;

    public boolean check(Event e) {
        return this.factions.check(e, faction -> Arrays.stream(faction.getMembers()).anyMatch(player -> player.getOfflinePlayer().isOnline()), this.isNegated());
    }

    public String toString(Event e, boolean debug) {
        return "any players " + (this.factions.isSingle() ? "is" : "are online in " + this.factions.toString(e, debug));
    }

    public boolean init(Expression<?>[] exprs, int matchedPattern, Kleenean isDelayed, SkriptParser.ParseResult parseResult) {
        this.factions = exprs[0];
        this.setNegated(matchedPattern == 1);
        return true;
    }

    static {
        Skript.registerCondition(CondAnyPlayersOnline.class, (String[])new String[]{"any [faction] player[s] (is|are) online [(from|of)] [faction][s] %conquerfactions%", "any [faction] player[s] (is(n't| not)|are(n't| not)) online [(from|of)] [faction][s] %conquerfactions%"});
    }
}

