/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAType;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.addoncore.annotations.Syntax;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.FactionsPlugin;

@Name(value="Faction/Kingdom/Guild")
@Description(value="Represents a faction/kingdom/guild")
@Syntax(value={"Retrieved via expressions"})
public class TypeFaction
extends ASAType<ConquerFaction> {
    @Override
    public ClassInfo<ConquerFaction> getClassInfo() {
        return new ClassInfo(ConquerFaction.class, "conquerfaction").name("faction").user(new String[]{"(conquer)?(faction|kingdom|guild)"}).parser((Parser)new Parser<ConquerFaction>(){

            public String toString(ConquerFaction faction, int i) {
                return faction.getName();
            }

            public String toVariableNameString(ConquerFaction faction) {
                return faction.getName();
            }

            public String getVariableNamePattern() {
                return ".+";
            }

            public boolean canParse(ParseContext context) {
                return false;
            }
        }).serializer((Serializer)new Serializer<ConquerFaction>(){

            public Fields serialize(ConquerFaction faction) throws NotSerializableException {
                Fields fields = faction.serialize();
                fields.putObject("impl", (Object)Conquer.getInstance().getFactionsPlugin().getClass().getCanonicalName());
                return fields;
            }

            public void deserialize(ConquerFaction faction, Fields fields) throws StreamCorruptedException, NotSerializableException {
                assert (false);
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }

            protected ConquerFaction deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                FactionsPlugin impl = null;
                try {
                    Class<?> implClass = Class.forName((String)fields.getObject("impl"));
                    impl = Conquer.getInstance().getFactionsPlugin().getClass().equals(implClass) ? Conquer.getInstance().getFactionsPlugin() : (FactionsPlugin)implClass.newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                if (impl == null) {
                    throw new StreamCorruptedException();
                }
                if (!impl.canBeUsed()) {
                    Conquer.getInstance().getLogger().warning(String.format("Trying to load a saved factions variable from a different factions plugin (%s) but it could not be loaded because that plugin is no longer on the server. Variable will be null.", impl.getClass().getCanonicalName()));
                    return null;
                }
                if (!impl.hasBeenInitialized()) {
                    impl.initialize();
                }
                return impl.deserializeFaction(fields);
            }
        }).defaultExpression((DefaultExpression)new EventValueExpression(ConquerFaction.class));
    }
}

