/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.types;

import ch.njol.skript.classes.ClassInfo;
import ch.njol.skript.classes.Parser;
import ch.njol.skript.classes.Serializer;
import ch.njol.skript.expressions.base.EventValueExpression;
import ch.njol.skript.lang.DefaultExpression;
import ch.njol.skript.lang.ParseContext;
import ch.njol.yggdrasil.Fields;
import java.io.NotSerializableException;
import java.io.StreamCorruptedException;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAType;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.addoncore.annotations.Syntax;
import me.andrew28.addons.conquer.api.Claim;
import me.andrew28.addons.conquer.api.FactionsPlugin;

@Name(value="Claim")
@Description(value="Represents a claim (usually a chunk)")
@Syntax(value={"Retrieved via expressions"})
public class TypeClaim
extends ASAType<Claim> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public ClassInfo<Claim> getClassInfo() {
        return new ClassInfo(Claim.class, "conquerclaim").name("claim").user(new String[]{"(conquer)?claim"}).parser((Parser)new Parser<Claim>(){

            public String toString(Claim claim, int flags) {
                return claim.representationObjectToString(claim.getRepresentationObject(), flags);
            }

            public String toVariableNameString(Claim claim) {
                return this.toString(claim, 0);
            }

            public String getVariableNamePattern() {
                return ".+";
            }

            public boolean canParse(ParseContext context) {
                return false;
            }
        }).serializer((Serializer)new Serializer<Claim>(){

            public Fields serialize(Claim claim) throws NotSerializableException {
                Fields fields = claim.serialize();
                fields.putObject("impl", (Object)TypeClaim.this.factionsPlugin.getClass().getCanonicalName());
                return fields;
            }

            public void deserialize(Claim claim, Fields fields) throws StreamCorruptedException, NotSerializableException {
                assert (false);
            }

            public boolean mustSyncDeserialization() {
                return false;
            }

            protected boolean canBeInstantiated() {
                return false;
            }

            protected Claim deserialize(Fields fields) throws StreamCorruptedException, NotSerializableException {
                FactionsPlugin impl = null;
                try {
                    Class<?> implClass = Class.forName((String)fields.getObject("impl"));
                    impl = TypeClaim.this.factionsPlugin.getClass().equals(implClass) ? TypeClaim.this.factionsPlugin : (FactionsPlugin)implClass.newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    e.printStackTrace();
                }
                if (impl == null) {
                    throw new StreamCorruptedException();
                }
                if (!impl.canBeUsed()) {
                    Conquer.getInstance().getLogger().warning(String.format("Trying to load a saved claims variable from a different factions plugin (%s) but it could not be loaded because that plugin is no longer on the server. Variable will be null.", impl.getClass().getCanonicalName()));
                    return null;
                }
                if (!impl.hasBeenInitialized()) {
                    impl.initialize();
                }
                return impl.deserializeClaim(fields);
            }
        }).defaultExpression((DefaultExpression)new EventValueExpression(Claim.class));
    }
}

