/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.players;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Display Name/Title of Player")
@Description(value="Retrieve the title (display name) a given player has in a faction/kingdom/guild")
@BSyntax(syntax={"[the] (faction|kingdom|guild) [display] [(title|name)] (of|for) %player%", "%player%'s (faction|kingdom|guild) [display] [(title|name)]"}, bind={"player"})
@Examples(value={@Example(value={"message \"Your Title: %faction title of player%\""})})
public class ExprTitleOfPlayer
extends ASAExpression<String> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public String getValue() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player is null");
        return this.factionsPlugin.getConquerPlayer(player).getTitle();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<String>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(String[] strings) throws NullExpressionException {
                Player player = (Player)ExprTitleOfPlayer.this.exp().get("player");
                ExprTitleOfPlayer.this.assertNotNull(player, "Player to set the faction title/name of is null");
                ExprTitleOfPlayer.this.factionsPlugin.getConquerPlayer(player).getTitle();
            }
        }, new ASAChanger<String>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.RESET, Changer.ChangeMode.DELETE, Changer.ChangeMode.REMOVE, Changer.ChangeMode.REMOVE_ALL};
            }

            public void change(String[] strings) throws NullExpressionException {
                Player player = (Player)ExprTitleOfPlayer.this.exp().get("player");
                ExprTitleOfPlayer.this.assertNotNull(player, "Player to clear the faction title/name of is null");
                ExprTitleOfPlayer.this.factionsPlugin.getConquerPlayer(player).resetTitle();
            }
        }};
    }
}

