/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.players;

import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import me.andrew28.addons.conquer.api.Role;
import org.bukkit.entity.Player;

@Name(value="Faction/Kingdom/Guild Rank/Role of Player")
@Description(value="Retrieve the faction/kingdom/guild rank/role of a given player")
@BSyntax(syntax={"[the] (faction|kingdom|guild) (rank|role) (of|for) [the] [player] %player%", "%player%'s (faction|kingdom|guild) (rank|role)"}, bind={"player"})
@Examples(value={@Example(value={"message \"Your Role: %role of player%\""})})
public class ExprRoleOfPlayer
extends ASAExpression<Role> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public Role getValue() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        return this.factionsPlugin.getConquerPlayer(player).getRole();
    }
}

