/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.players;

import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Minimum Power of Player")
@Description(value="Retrieve the minimum power of a given player")
@BSyntax(syntax={"[the] min[imum] power [level] of [player] %player%", "%player%'s min[imum] power [level]"}, bind={"player"})
@Examples(value={@Example(value={"message \"Your minimum power: %min power of player%\""})})
public class ExprMinimumPowerOfPlayer
extends ASAExpression<Double> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public Double getValue() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        return this.factionsPlugin.getConquerPlayer(player).getMinimumPower();
    }
}

