/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.players;

import ch.njol.skript.util.Date;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Last Activity Of Player")
@Description(value="Retrieve when a given player was last active")
@BSyntax(syntax={"[the] last activ(ity|e) [(date|time)] (for|or|of) [player] %player%", "%player%'s last activ(ity|e) (date|time)"}, bind={"player"})
@Examples(value={@Example(value={"message \"Your last activity: %last activity of player%\""})})
public class ExprLastActivityOfPlayer
extends ASAExpression<Date> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public Date getValue() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        return new Date(this.factionsPlugin.getConquerPlayer(player).getLastActivity().getTime());
    }
}

