/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.players;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Faction/Kingdom/Guild Of Player")
@Description(value="Retrieve the faction/kingdom/guild of a given player")
@BSyntax(syntax={"[the] [current] (faction|kingdom|guild) (of|for) [player] %player%", "%player%'s [current] (faction|kingdom|guild)"}, bind={"player"})
@Examples(value={@Example(value={"message \"Your Faction: %faction of player%\""})})
public class ExprFactionOfPlayer
extends ASAExpression<ConquerFaction> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public ConquerFaction getValue() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        return this.factionsPlugin.getConquerPlayer(player).getFaction();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<ConquerFaction>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(ConquerFaction[] factions) throws NullExpressionException {
                Player player = (Player)ExprFactionOfPlayer.this.exp().get("player");
                ExprFactionOfPlayer.this.assertNotNull(player, "Player given to set the faction of is null");
                ExprFactionOfPlayer.this.factionsPlugin.getConquerPlayer(player).setFaction(factions[0]);
            }
        }, new ASAChanger<ConquerFaction>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.DELETE, Changer.ChangeMode.REMOVE, Changer.ChangeMode.RESET};
            }

            public void change(ConquerFaction[] factions) throws NullExpressionException {
                Player player = (Player)ExprFactionOfPlayer.this.exp().get("player");
                ExprFactionOfPlayer.this.assertNotNull(player, "Player given to remove the faction of is null");
                ExprFactionOfPlayer.this.factionsPlugin.getConquerPlayer(player).resetFaction();
            }
        }};
    }
}

