/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.players;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Automatic Map Update Mode of Player")
@Description(value="Retrieve the automatic map update mode of a given player")
@BSyntax(syntax={"[the] auto[matic] map [update] (mode|state|status) (of|for) [player] %player%", "%player%'s auto[matic] map [update] (mode|state|status)"}, bind={"player"})
@Examples(value={@Example(value={"message \"Auto Map Mode: %auto map mode of player%\""})})
public class ExprAutoMapUpdateStatusOfPlayer
extends ASAExpression<Boolean> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public Boolean getValue() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        return this.factionsPlugin.getConquerPlayer(player).getAutomaticMapUpdateMode();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<Boolean>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(Boolean[] booleans) throws NullExpressionException {
                Player player = (Player)ExprAutoMapUpdateStatusOfPlayer.this.exp().get("player");
                ExprAutoMapUpdateStatusOfPlayer.this.assertNotNull(player, "Player given to change the automatic map update mode of is null");
                ExprAutoMapUpdateStatusOfPlayer.this.factionsPlugin.getConquerPlayer(player).setAutomaticMapUpdateMode(booleans[0]);
            }
        }, new ASAChanger<Boolean>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.RESET};
            }

            public void change(Boolean[] booleans) throws NullExpressionException {
                Player player = (Player)ExprAutoMapUpdateStatusOfPlayer.this.exp().get("player");
                ExprAutoMapUpdateStatusOfPlayer.this.assertNotNull(player, "Player given to reset the automatic map update mode of is null");
                ExprAutoMapUpdateStatusOfPlayer.this.factionsPlugin.getConquerPlayer(player).setAutomaticMapUpdateMode(false);
            }
        }};
    }
}

