/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.players;

import ch.njol.skript.classes.Changer;
import me.andrew28.addons.conquer.Conquer;
import me.andrew28.addons.conquer.addoncore.ASAChanger;
import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.BSyntax;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.api.FactionsPlugin;
import org.bukkit.entity.Player;

@Name(value="Auto Claiming Status/State/Mode of a Player")
@Description(value="Retrieve the auto claiming status/state/mode for a given player")
@BSyntax(syntax={"[the] auto[matic][ ]claim[ing] ((stat(e|us))|mode) (of|for|from) [player] %player%", "%player%'s auto[matic][ ]claim[ing] ((stat(e|us))|mode)"}, bind={"player"})
@Examples(value={@Example(value={"message \"Auto Claim Mode: %auto claim state of player%\""})})
public class ExprAutoClaimStatusOfPlayer
extends ASAExpression<Boolean> {
    private FactionsPlugin factionsPlugin = Conquer.getInstance().getFactionsPlugin();

    @Override
    public Boolean getValue() throws NullExpressionException {
        Player player = (Player)this.exp().get("player");
        this.assertNotNull(player, "Player given is null");
        return this.factionsPlugin.getConquerPlayer(player).isAutoClaiming();
    }

    @Override
    public ASAChanger[] getChangers() {
        return new ASAChanger[]{new ASAChanger<Boolean>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.SET};
            }

            public void change(Boolean[] booleans) throws NullExpressionException {
                Player player = (Player)ExprAutoClaimStatusOfPlayer.this.exp().get("player");
                ExprAutoClaimStatusOfPlayer.this.assertNotNull(player, "Player given to set auto claim mode of is null");
                ExprAutoClaimStatusOfPlayer.this.factionsPlugin.getConquerPlayer(player).setAutoClaiming(booleans[0]);
            }
        }, new ASAChanger<Boolean>(){

            @Override
            public Changer.ChangeMode[] getChangeModes() {
                return new Changer.ChangeMode[]{Changer.ChangeMode.RESET};
            }

            public void change(Boolean[] booleans) throws NullExpressionException {
                Player player = (Player)ExprAutoClaimStatusOfPlayer.this.exp().get("player");
                ExprAutoClaimStatusOfPlayer.this.assertNotNull(player, "Player given to reset auto claim mode of is null");
            }
        }};
    }
}

