/*
 * Decompiled with CFR 0.152.
 */
package me.andrew28.addons.conquer.skript.expressions.factions;

import me.andrew28.addons.conquer.addoncore.ASAExpression;
import me.andrew28.addons.conquer.addoncore.NullExpressionException;
import me.andrew28.addons.conquer.addoncore.annotations.Description;
import me.andrew28.addons.conquer.addoncore.annotations.Example;
import me.andrew28.addons.conquer.addoncore.annotations.Examples;
import me.andrew28.addons.conquer.addoncore.annotations.Name;
import me.andrew28.addons.conquer.addoncore.annotations.Syntax;
import me.andrew28.addons.conquer.api.ConquerFaction;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationChangeEvent;
import me.andrew28.addons.conquer.api.events.ConquerFactionRelationWishEvent;
import org.bukkit.event.Event;

@Name(value="Sender of Faction/Kingdom/Guild Relation Change/Wish")
@Description(value="Retrieve the sender (the factions/kingdom/guild who started) of a relation change/wish event")
@Syntax(value={"sender faction [of] [(faction|kingdom|guild)] [relation] [change|wish]"})
@Examples(value={@Example(value={"#or faction relation wish", "on faction relation change:", "\tbroadcast \"Sender: %sender faction%\""})})
public class ExprSenderOfFactionRelationChange
extends ASAExpression<ConquerFaction> {
    @Override
    public ConquerFaction getValue() throws NullExpressionException {
        if (this.getCurrentEvent() instanceof ConquerFactionRelationChangeEvent) {
            return ((ConquerFactionRelationChangeEvent)this.getCurrentEvent()).getSender();
        }
        if (this.getCurrentEvent() instanceof ConquerFactionRelationWishEvent) {
            return ((ConquerFactionRelationWishEvent)this.getCurrentEvent()).getSender();
        }
        return null;
    }

    @Override
    public Class<? extends Event>[] getRequiredEvents() {
        return new Class[]{ConquerFactionRelationChangeEvent.class, ConquerFactionRelationWishEvent.class};
    }
}

